/*
** UVC_defs.c
**
** Copyright  2010 Future Devices International Limited
**
** Company Confidential
**
** C Header file for Vinculum II USB Video Class driver
** Main module
**
** Author:
** Project: Vinculum II
** Module: Vinculum II USB Video Class Driver
** Requires: VOS
** Comments: Internal definitions
**
** History:
**  1  Initial version
**
*/

#ifndef __uvc_defs_h__
#define __uvc_defs_h__


//
// UVC Context
//
typedef struct _uvc_context_t
{
    // host controller handle
    VOS_HANDLE hc;

    unsigned short vid;
    unsigned short pid;

    // endpoint handles
    usbhost_ep_handle *epInt;
    usbhost_ep_handle *epCtrl;
    usbhost_ep_handle *epIsoIn;

    // endpoint info
    usbhost_ioctl_cb_ep_info_t epInfo;

    unsigned char state;

} uvc_context_t;


// read function
unsigned char uvc_read (
    char *buffer,
    unsigned short num_to_read,
    unsigned short *num_read,
    uvc_context_t *ctx);

// write function
unsigned char uvc_write (
    char *buffer,
    unsigned short num_to_write,
    unsigned short *num_written,
    uvc_context_t *ctx);

// USB Host IOCTL function
unsigned char uvc_ioctl (uvc_ioctl_cb_t *cb,
    uvc_context_t *ctx);

void uvc_open (uvc_context_t *ctx);
void uvc_close (uvc_context_t *ctx);



#endif /* __uvc_defs_h__ */

