/*
** UVC.h
**
** Copyright  2010 Future Devices International Limited
**
** Company Confidential
**
** C Header file for Vinculum II USB Video Class driver
** Main module
**
** Author:
** Project: Vinculum II
** Module: Vinculum II USB Video Class Driver
** Requires: VOS
** Comments:
**
** History:
**  1  Initial version
**
*/

#ifndef __uvc_h__
#define __uvc_h__

#define UVC_VERSION_STRING "1.2.0"


#define USB_CC_VIDEO                 0xEF
#define USB_SC_VIDEOSTREAMING        0x02
#define USB_PC_PROTOCOL_UNDEFINED    0x01

//IOCTLS
#define VOS_IOCTL_UVC_ATTACH         1
#define VOS_IOCTL_UVC_DETACH         2
#define VOS_IOCTL_UVC_CLASS_REQUEST  3

//
// RET values
//
enum uvc_ret_e
{
    UVC_OK,
    UVC_INVALID_PARAMETER,
    UVC_NOT_FOUND,
    UVC_ERROR
};

//
// Video Probe and Commit Controls
// Streaming parameters
// Device Class Definition for Video Drivers 4.3.1.1
//
typedef struct _uvc_vs_probe_and_commit_control_t
{

    unsigned short bmHint;
    unsigned char bFormatIndex;
    unsigned char bFrameIndex;
    unsigned int dwFrameInterval;
    unsigned short wKeyFrameRate;
    unsigned short wPFrameRate;
    unsigned short wCompQuality;
    unsigned short wCompWindowSize;
    unsigned short wDelay;
    unsigned int dwMaxVideoFrameSize;
    unsigned int dwMaxPayloadTransferSize;
    unsigned int dwClockFrequency;
    unsigned char bmFramingInfo;
    unsigned char bPreferedVersion;
    unsigned char bMinVersion;
    unsigned char bMaxVersion;

} uvc_vs_probe_and_commit_control_t;


//
// UVC request codes
//
enum uvc_vs_request_code_e
{
    RC_UNDEFINED=0x00,   //0x00
    SET_CUR,             //0x01
    GET_CUR= 0x81,       //0x81
    GET_MIN,             //0x82
    GET_MAX,             //0x83
    GET_RES,             //0x84
    GET_LEN,             //0x85
    GET_INFO,            //0x86
    GET_DEF              //0x87
};


//
// configure request structure for VOS_IOCTL_UVC_CLASS_REQUEST
//
#define set_class_request(d,iface,ent,cs,code,len)     \
    do {                                               \
        (d).bRequest = (code);                         \
        (d).wValue = ((cs)<<8);                        \
        (d).wIndex = (((ent)<<8)|(iface));             \
        (d).wLength = (len);                           \
    } while (0)


//
// UVC ioctl parameter structure
//
typedef struct _uvc_ioctl_cb_t
{
    unsigned char ioctl_code;
    // read buffer
    unsigned char *get;
    // write butter
    unsigned char *set;

} uvc_ioctl_cb_t;



/////////////////////////////////////////////////////////////////////////////
// library routines
/////////////////////////////////////////////////////////////////////////////
unsigned char uvc_init(
    unsigned char vos_dev_num);


#endif /* __uvc_h__ */

