/*
** IOMux.c
**
** C Source file for Vinculum II IOMux Configuration
**
** Author: FTDI IOMux Configuration Application
** Project:
** Module:
** Requires: VOS
** Comments: Automatically Generated File
**
** History:
** 1 Initial version
**
*/

#include "vos.h"

#ifdef _VNC2
port vII_gpio_sys_cntrl_1@0x180;
port vII_gpio_cntrl_pa_1@0x181;
port vII_gpio_cntrl_pb_1@0x182;
port vII_gpio_cntrl_pc_1@0x183;
port vII_gpio_cntrl_pd_1@0x184;
port vII_gpio_data_tx_pa_1@0x186;
port vII_gpio_data_tx_pb_1@0x187;
port vII_gpio_data_tx_pc_1@0x188;
port vII_gpio_data_tx_pd_1@0x189;
port vII_gpio_data_tx_pe_1@0x18a;
port vII_gpio_data_rx_pa_1@0x18b;
#endif

#define WR vII_gpio_data_tx_pb_1.0
#define RD vII_gpio_data_tx_pb_1.1
#define CS vII_gpio_data_tx_pb_1.2
#define RS vII_gpio_data_tx_pb_1.3
#define DOTCLK vII_gpio_data_tx_pb_1.4
#define HSYNC vII_gpio_data_tx_pb_1.5
#define VSYNC vII_gpio_data_tx_pb_1.6
#define ENABLE vII_gpio_data_tx_pb_1.7
#define RES vII_gpio_data_tx_pd_1.6


// SEPS525 Registers

#define SEPS525_INDEX                      0x00
#define SEPS525_STATUS_RD                  0x01
#define SEPS525_OSC_CTL                    0x02
#define SEPS525_CLOCK_DIV                  0x03
#define SEPS525_REDUCE_CURRENT             0x04
#define SEPS525_SOFT_RST                   0x05
#define SEPS525_DISP_ON_OFF                0x06
#define SEPS525_PRECHARGE_TIME_R           0x08
#define SEPS525_PRECHARGE_TIME_G           0x09
#define SEPS525_PRECHARGE_TIME_B           0x0a
#define SEPS525_PRECHARGE_CURRENT_R        0x0b
#define SEPS525_PRECHARGE_CURRENT_G        0x0c
#define SEPS525_PRECHARGE_CURRENT_B        0x0d
#define SEPS525_DRIVING_CURRENT_R          0x10
#define SEPS525_DRIVING_CURRENT_G          0x11
#define SEPS525_DRIVING_CURRENT_B          0x12
#define SEPS525_DISPLAY_MODE_SET           0x13
#define SEPS525_RGB_IF                     0x14
#define SEPS525_RGB_POL                    0x15
#define SEPS525_MEMORY_WRITE_MODE          0x16
#define SEPS525_MX1_ADDR                   0x17
#define SEPS525_MX2_ADDR                   0x18
#define SEPS525_MY1_ADDR                   0x19
#define SEPS525_MY2_ADDR                   0x1a
#define SEPS525_MEMORY_ACCESS_POINTER_X    0x20
#define SEPS525_MEMORY_ACCESS_POINTER_Y    0x21
#define SEPS525_DUTY                       0x28
#define SEPS525_DSL                        0x29
#define SEPS525_D1_DDRAM_FAC               0x2e
#define SEPS525_D1_DDRAM_FAR               0x2f
#define SEPS525_D2_DDRAM_SAC               0x31
#define SEPS525_D2_DDRAM_SAR               0x32
#define SEPS525_SCR1_FX1                   0x33
#define SEPS525_SCR1_FX2                   0x34
#define SEPS525_SCR1_FY1                   0x35
#define SEPS525_SCR1_FY2                   0x36
#define SEPS525_SCR2_SX1                   0x37
#define SEPS525_SCR2_SX2                   0x38
#define SEPS525_SCR2_SY1                   0x39
#define SEPS525_SCR2_SY2                   0x3a
#define SEPS525_SCREEN_SAVER_CONTROL       0x3b
#define SEPS525_SS_SLEEP_TIMER             0x3c
#define SEPS525_SCREEN_SAVER_MODE          0x3d
#define SEPS525_SS_SCR1_FU                 0x3e
#define SEPS525_SS_SCR1_MXY                0x3f
#define SEPS525_SS_SCR2_FU                 0x40
#define SEPS525_SS_SCR2_MXY                0x41
#define SEPS525_MOVING_DIRECTION           0x42
#define SEPS525_SS_SCR2_SX1                0x47
#define SEPS525_SS_SCR2_SX2                0x48
#define SEPS525_SS_SCR2_SY1                0x49
#define SEPS525_SS_SCR2_SY2                0x4a
#define SEPS525_GRAY_SCALE_TABLE_INDEX     0x50
#define SEPS525_GRAY_SCALE_TABLE_DATA      0x51
#define SEPS525_IREF                       0x80

#define Write_Command    SEPS525_write_c
#define Write_Data       SEPS525_write_d
#define Read_Data        SEPS525_read_d


void SEPS525_write_c(unsigned char cmnd)
{
    RS = 0;
    CS = 0;
    WR = 0;
    vII_gpio_data_tx_pa_1 = cmnd;
    WR = 1;
    CS = 1;
    RS = 1;
}

void SEPS525_write_d(unsigned char data)
{
    RS = 1;
    CS = 0;
    WR = 0;
    vII_gpio_data_tx_pa_1 = data;
    WR = 1;
    CS = 1;
    RS = 1;
}

unsigned char SEPS525_read_d(void)
{
    unsigned char d;

    vII_gpio_cntrl_pa_1 = 0x00;

    RS = 0;
    CS = 0;
    RD = 0;
    d = vII_gpio_data_rx_pa_1;
    RD = 1;
    CS = 1;
    RS = 1;

    vII_gpio_cntrl_pa_1 = 0xff;

    return d;
}

void SEPS525_reset(void)
{
    //
    // A necessary step in initialisation
    // is to change the sense of the gpios
    // from input to output.
    //

    vII_gpio_sys_cntrl_1 = 0x03;

    vII_gpio_cntrl_pa_1 = 0x00;
    vII_gpio_cntrl_pb_1 = 0xff;
    vII_gpio_cntrl_pd_1 = 0x40;

    vII_gpio_data_tx_pa_1 = 0x00;
    vII_gpio_data_tx_pb_1 = 0x00;
    vII_gpio_data_tx_pd_1 = 0x00;

    RES = 0;
    vos_delay_msecs(200);
    RES = 1;

    vII_gpio_cntrl_pa_1 = 0xff;

    RS = 0;
    RD = 1;
    WR = 1;
    CS = 1;
}

void SEPS525_init(void)
{
#if 0
    unsigned char d,d1,d2,d3;

    SEPS525_write_c(SEPS525_MEMORY_WRITE_MODE);
    SEPS525_write_d(0x76);    // 0x76

    SEPS525_write_c(SEPS525_DISP_ON_OFF);
    SEPS525_write_d(0x00);

    SEPS525_write_c(SEPS525_OSC_CTL);
    SEPS525_write_d(0x01);

    SEPS525_write_c(SEPS525_CLOCK_DIV);
    SEPS525_write_d(0xF0);    // 115Hz

    SEPS525_write_c(SEPS525_REDUCE_CURRENT);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_IREF);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_PRECHARGE_TIME_R);
    SEPS525_write_d(0x01);
    SEPS525_write_c(SEPS525_PRECHARGE_TIME_G);
    SEPS525_write_d(0x01);
    SEPS525_write_c(SEPS525_PRECHARGE_TIME_B);
    SEPS525_write_d(0x02);
    SEPS525_write_c(SEPS525_PRECHARGE_CURRENT_R);
    SEPS525_write_d(0x0c);
    SEPS525_write_c(SEPS525_PRECHARGE_CURRENT_G);
    SEPS525_write_d(0x19);
    SEPS525_write_c(SEPS525_PRECHARGE_CURRENT_B);
    SEPS525_write_d(0x15);
    SEPS525_write_c(SEPS525_DRIVING_CURRENT_R);
    SEPS525_write_d(0x32);
    SEPS525_write_c(SEPS525_DRIVING_CURRENT_G);
    SEPS525_write_d(0x27);
    SEPS525_write_c(SEPS525_DRIVING_CURRENT_B);
    SEPS525_write_d(0x2b);
    SEPS525_write_c(SEPS525_DISPLAY_MODE_SET);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_RGB_IF);
    SEPS525_write_d(0x21);

    SEPS525_write_c(SEPS525_RGB_POL);
    SEPS525_write_d(0x00);

//    SEPS525_write_c(SEPS525_MEMORY_WRITE_MODE);
//    SEPS525_write_d(0x76);    // 0x76

    SEPS525_write_c(SEPS525_MX1_ADDR);
    SEPS525_write_d(0x00);

    SEPS525_write_c(SEPS525_MX2_ADDR);
    SEPS525_write_d(0x9f);
    SEPS525_write_c(SEPS525_MY1_ADDR);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_MY2_ADDR);
    SEPS525_write_d(0x7f);
    SEPS525_write_c(SEPS525_MEMORY_ACCESS_POINTER_X);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_MEMORY_ACCESS_POINTER_Y);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_DUTY);
    SEPS525_write_d(0x7f);
    SEPS525_write_c(SEPS525_DSL);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_D1_DDRAM_FAC);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_D1_DDRAM_FAR);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_D2_DDRAM_SAC);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_D2_DDRAM_SAR);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_SCR1_FX1);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_SCR1_FX2);
    SEPS525_write_d(0x9f);
    SEPS525_write_c(SEPS525_SCR1_FY1);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_SCR1_FY2);
    SEPS525_write_d(0x7f);

    SEPS525_write_c(SEPS525_DISP_ON_OFF);
    SEPS525_write_d(0x01);
    SEPS525_write_c(SEPS525_DISP_ON_OFF);
    d = SEPS525_read_d();
#endif

    return;
}

void SEPS525_white_pattern(void)
{
    short i,j;

    SEPS525_write_c(SEPS525_MEMORY_ACCESS_POINTER_X);
    SEPS525_write_d(0x00);
    SEPS525_write_c(SEPS525_MEMORY_ACCESS_POINTER_Y);
    SEPS525_write_d(0x00);
    SEPS525_write_c(0x22);

    for (i=0; i<128; i++) {
        for (j=0; j<160; j++) {
            SEPS525_write_d(0xfc);
            SEPS525_write_d(0xfc);
//            SEPS525_write_d(0xfc);
        }
    }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Delay Time
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void uDelay(unsigned char l)
{
    while(l--);
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Instruction Setting
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Set_Read_Index(unsigned char d)
{
    Write_Command(0x00);            // Read Index Address of Registers (INDEX)
//    Read_Data(d);                //   Default => 0x00
}


void Set_Read_Status(unsigned char d)
{
    Write_Command(0x01);            // Read Internal Status (STATUS_RD)
//    Read_Data(d);                //   Default => 0xC0
}


void Set_Clock_Control(unsigned char d)
{
    Write_Command(0x02);            // Set Oscillator Control (OSC_CTL)
    Write_Data(d);                //   Default => 0xC0
                        //     EXPORT1 Pin at Low Level
                        //     Oscillator operates with internal resister.
                        //     Clock Off
}


void Set_Display_Clock(unsigned char d)
{
    Write_Command(0x03);            // Set Display Frequency Divide Ration / Oscillator Frequency (CLOCK_DIV)
    Write_Data(d);                //   Default => 0x30 (90 Hz / Divide Ration = 1)
                        //     D[3:0] => Display Frequency Divide Ration
                        //     D[7:4] => Oscillator Frequency
}


void Set_Power_Save(unsigned char d)
{
    Write_Command(0x04);            // Set Power Save Mode (REDUCE_CURRENT)
    Write_Data(d);                //   Default => 0x00
                        //     Normal Driving Current
                        //     Disable Oscillator Power Down
                        //     Disable Power Save Mode
}


void Software_Reset(unsigned char d)
{
    Write_Command(0x05);            // Software Reset (SOFT_RST)
    Write_Data(d);                //   Default => 0x00
                        //     0x00 => Normal Mode
                        //     0x01 => All internal register values will be default.
}


void Set_Display_On_Off(unsigned char d)
{
    Write_Command(0x06);            // Set Display On/Off (DISP_ON_OFF)
    Write_Data(d);                //   Default => 0x00
                        //     Scan signal is high level at pre-charge period.
                        //     Display Off
}


void Set_Precharge_Period(unsigned char a, unsigned char b, unsigned char c)
{
    Write_Command(0x08);            // Set Pre-Charge Time of Red (PRECHARGE_TIME_R)
    Write_Data(a);                //   Default => 0x00
    Write_Command(0x09);            // Set Pre-Charge Time of Green (PRECHARGE_TIME_G)
    Write_Data(b);                //   Default => 0x00
    Write_Command(0x0A);            // Set Pre-Charge Time of Blue (PRECHARGE_TIME_B)
    Write_Data(c);                //   Default => 0x00
}


void Set_Precharge_Current(unsigned char a, unsigned char b, unsigned char c)
{
    unsigned char a1;
    unsigned char b1;
    unsigned char c1;

    Write_Command(0x0B);            // Set Pre-Charge Current of Red (PRECHARGE_CURRENT_R)
    Write_Data(a);                //   Default => 0x00
    Write_Command(0x0B);            // Set Pre-Charge Current of Red (PRECHARGE_CURRENT_R)
    a1 = Read_Data();
    Write_Command(0x0C);            // Set Pre-Charge Current of Green (PRECHARGE_CURRENT_G)
    Write_Data(b);                //   Default => 0x00
    Write_Command(0x0D);            // Set Pre-Charge Current of Blue (PRECHARGE_CURRENT_B)
    Write_Data(c);                //   Default => 0x00
}


void Set_Driving_Current(unsigned char a, unsigned char b, unsigned char c)
{
    Write_Command(0x10);            // Set Driving Current of Red (DRIVING_CURRENT_R)
    Write_Data(a);                //   Default => 0x00
    Write_Command(0x11);            // Set Driving Current of Green (DRIVING_CURRENT_G)
    Write_Data(b);                //   Default => 0x00
    Write_Command(0x12);            // Set Driving Current of Blue (DRIVING_CURRENT_B)
    Write_Data(c);                //   Default => 0x00
}


void Set_Display_Mode(unsigned char d)
{
    Write_Command(0x13);            // Set Column Data Display Control / Re-Map Format (DISPLAY_MODE_SET)
    Write_Data(d);                //   Default => 0x00
                        //     Color Sequence: R => G => B
                        //     Alternative Gate Pin Configuration
                        //     Scan from G0 to G[N-1]
                        //     Column Address 0 Mapped to S0
                        //     One Screen Mode
                        //     Normal Display
}


void Set_RGB_IF(unsigned char d)
{
    Write_Command(0x14);            // Set Interface Mode (RGB_IF)
    Write_Data(d);                //   Default => 0x11 (MCU Interface Mode)
}


void Set_RGB_POL(unsigned char d)
{
    Write_Command(0x15);            // Set RGB Interface Polarity (RGB_POL)
    Write_Data(d);                //   Default => 0x00
                        //     Enable Polarity as Active Low
                        //     Dot Clock Polarity Sampled as Rising Edge
                        //     Disable Vertical Synchronization Output on VSYNCO Pin
}


void Set_Pixel_Format(unsigned char d)
{
    Write_Command(0x16);            // Set Memory Access Control / Interface Pixel Format (MEMORY_WRITE_MODE)
    Write_Data(d);                //   Default => 0x06
                        //     Enable 18-bit Bus Interface
                        //     262,144 Colors
                        //     Horizontal address counter is increased.
                        //     Vertical address counter is increased.
                        //     The data is continuously written horizontally.
}


void Set_Column_Address(unsigned char a, unsigned char b)
{
    Write_Command(0x17);            // Set Column Address of Start (MX1_ADDR)
    Write_Data(a);                //   Default => 0x00
    Write_Command(0x18);            // Set Column Address of End (MX2_ADDR)
    Write_Data(b);                //   Default => 0x9F
}


void Set_Row_Address(unsigned char a, unsigned char b)
{
    Write_Command(0x19);            // Set Row Address of Start (MY1_ADDR)
    Write_Data(a);                //   Default => 0x00
    Write_Command(0x1A);            // Set Row Address of End (MY2_ADDR)
    Write_Data(b);                //   Default => 0x7F
}


void Set_Display_Offset(unsigned char a, unsigned char b)
{
    Write_Command(0x20);            // Specify the Horizontal Start Position of a Window for Written in Memory (MEMORY_ACCESSPOINTER X)
    Write_Data(a);                //   Default => 0x00
    Write_Command(0x21);            // Specify the Vertical Start Position of a Window for Written in Memory (MEMORY_ACCESSPOINTER Y)
    Write_Data(b);                //   Default => 0x00
}


void Set_Write_RAM()
{
    Write_Command(0x22);            // Internal DDRAM Memory Access (DDRAM_DATA_ACCESS_PORT)
}


void Set_Multiplex_Ratio(unsigned char d)
{
    Write_Command(0x28);            // Display Duty Ratio (DUTY)
    Write_Data(d);                //   Default => 0x7F (1/128 Duty)
}


void Set_Start_Line(unsigned char d)
{
    Write_Command(0x29);            // Set Display Start Line (DSL)
    Write_Data(d);                //   Default => 0x00
}


void Set_IREF(unsigned char d)
{
    Write_Command(0x80);            // Control Reference Voltage Generation (IREF)
    Write_Data(d);                //   Default => 0x00 (Reference Voltage Controlled by External Resister)
}

//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Global Variables
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#define    Color_Depth    0x00            // "0x00" => 65,536 Colors Mode
                        // "0x01" => 262,144 Colors Mode
#define Max_Column    0x9F            // 160-1
#define Max_Row        0x7F            // 128-1
#define    Brightness    0xFF


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Show Regular Pattern (Full Screen)
//
//    a: RRRRRGGG
//    b: GGGBBBBB
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Fill_RAM(unsigned char a, unsigned char b)
{
unsigned char i,j;

    Set_Display_Offset(0x00,0x00);
    Set_Column_Address(0x00,0x9F);
    Set_Row_Address(0x00,0x7F);
    Set_Write_RAM();

    for(i=0;i<128;i++)
    {
        for(j=0;j<160;j++)
        {
            Write_Data(a);
            Write_Data(b);
        }
    }
}

//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Show Regular Pattern (Partial or Full Screen)
//
//    a: Column Address of Start
//    b: Column Address of End
//    c: Row Address of Start
//    d: Row Address of End
//    e: RRRRRGGG
//    f: GGGBBBBB
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Fill_Block(unsigned char a, unsigned char b, unsigned char c, unsigned char d, unsigned char e, unsigned char f)
{
unsigned char i,j;

    Set_Display_Offset(a,c);
    Set_Column_Address(a,b);
    Set_Row_Address(c,d);
    Set_Write_RAM();

    for(i=0;i<(d-c+1);i++)
    {
        for(j=0;j<(b-a+1);j++)
        {
            Write_Data(e);
            Write_Data(f);
        }
    }
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Show Checkboard (Full Screen)
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Checkerboard()
{
unsigned char i,j;

    Set_Display_Offset(0x00,0x00);
    Set_Column_Address(0x00,0x9F);
    Set_Row_Address(0x00,0x7F);
    Set_Write_RAM();

    for(i=0;i<64;i++)
    {
        for(j=0;j<80;j++)
        {
            Write_Data(0xFF);
            Write_Data(0xFF);
            Write_Data(0x00);
            Write_Data(0x00);
        }
        for(j=0;j<80;j++)
        {
            Write_Data(0x00);
            Write_Data(0x00);
            Write_Data(0xFF);
            Write_Data(0xFF);
        }
    }
}

 //-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Show Color Bar (Full Screen)
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Rainbow()
{
    // White => Column 1~20
        Fill_Block(0x00,0x13,0x00,Max_Row,0xFF,0xFF);

    // Yellow => Column 21~40
        Fill_Block(0x14,0x27,0x00,Max_Row,0xFF,0xE0);

    // Purple => Column 41~60
        Fill_Block(0x28,0x3B,0x00,Max_Row,0xF8,0x1F);

    // Cyan => Column 61~80
        Fill_Block(0x3C,0x4F,0x00,Max_Row,0x07,0xFF);

    // Red => Column 81~100
        Fill_Block(0x50,0x63,0x00,Max_Row,0xF8,0x00);

    // Green => Column 101~120
        Fill_Block(0x64,0x77,0x00,Max_Row,0x07,0xE0);

    // Blue => Column 121~140
        Fill_Block(0x78,0x8B,0x00,Max_Row,0x00,0x1F);

    // Black => Column 141~160
        Fill_Block(0x8C,Max_Column,0x00,Max_Row,0x00,0x00);
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  First Screen Active Range (Partial or Full Screen)
//
//    a: Column Address of Start
//    b: Column Address of End
//    c: Row Address of Start
//    d: Row Address of End
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void First_Screen(unsigned char a, unsigned char b, unsigned char c, unsigned char d)
{
    Write_Command(0x2E);            // Set Column Address of Start Point (D1_DDRAM_FAC)
    Write_Data(a);                //   Default => 0x00
    Write_Command(0x2F);            // Set Row Address of Start Point (D1_DDRAM_FAR)
    Write_Data(c);                //   Default => 0x9F
    Write_Command(0x33);            // Set Column Address of Start (SCR1_FX1)
    Write_Data(a);                //   Default => 0x00
    Write_Command(0x34);            // Set Column Address of End (SCR1_FX2)
    Write_Data(b);                //   Default => 0x9F
    Write_Command(0x35);            // Set Row Address of Start (SCR1_FY1)
    Write_Data(c);                //   Default => 0x00
    Write_Command(0x36);            // Set Row Address of End (SCR1_FY2)
    Write_Data(d);                //   Default => 0x7F
}


//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Gray Scale Table Setting (Full Screen)
//-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void Set_Gray_Scale_Table()
{
    Write_Command(0x50);
    Write_Data(0x00);            // Gray Scale Level 1 of Red
    Write_Command(0x51);
    Write_Data(0x01);
    Write_Command(0x50);
    Write_Data(0x01);            // Gray Scale Level 3 of Red
    Write_Command(0x51);
    Write_Data(0x0A);
    Write_Command(0x50);
    Write_Data(0x02);            // Gray Scale Level 5 of Red
    Write_Command(0x51);
    Write_Data(0x10);
    Write_Command(0x50);
    Write_Data(0x03);            // Gray Scale Level 7 of Red
    Write_Command(0x51);
    Write_Data(0x15);
    Write_Command(0x50);
    Write_Data(0x04);            // Gray Scale Level 9 of Red
    Write_Command(0x51);
    Write_Data(0x19);
    Write_Command(0x50);
    Write_Data(0x05);            // Gray Scale Level 11 of Red
    Write_Command(0x51);
    Write_Data(0x1E);
    Write_Command(0x50);
    Write_Data(0x06);            // Gray Scale Level 13 of Red
    Write_Command(0x51);
    Write_Data(0x23);
    Write_Command(0x50);
    Write_Data(0x07);            // Gray Scale Level 15 of Red
    Write_Command(0x51);
    Write_Data(0x28);
    Write_Command(0x50);
    Write_Data(0x08);            // Gray Scale Level 17 of Red
    Write_Command(0x51);
    Write_Data(0x2D);
    Write_Command(0x50);
    Write_Data(0x09);            // Gray Scale Level 19 of Red
    Write_Command(0x51);
    Write_Data(0x33);
    Write_Command(0x50);
    Write_Data(0x0A);            // Gray Scale Level 21 of Red
    Write_Command(0x51);
    Write_Data(0x38);
    Write_Command(0x50);
    Write_Data(0x0B);            // Gray Scale Level 23 of Red
    Write_Command(0x51);
    Write_Data(0x3D);
    Write_Command(0x50);
    Write_Data(0x0C);            // Gray Scale Level 25 of Red
    Write_Command(0x51);
    Write_Data(0x43);
    Write_Command(0x50);
    Write_Data(0x0D);            // Gray Scale Level 27 of Red
    Write_Command(0x51);
    Write_Data(0x47);
    Write_Command(0x50);
    Write_Data(0x0E);            // Gray Scale Level 29 of Red
    Write_Command(0x51);
    Write_Data(0x4D);
    Write_Command(0x50);
    Write_Data(0x0F);            // Gray Scale Level 31 of Red
    Write_Command(0x51);
    Write_Data(0x52);
    Write_Command(0x50);
    Write_Data(0x10);            // Gray Scale Level 33 of Red
    Write_Command(0x51);
    Write_Data(0x57);
    Write_Command(0x50);
    Write_Data(0x11);            // Gray Scale Level 35 of Red
    Write_Command(0x51);
    Write_Data(0x5C);
    Write_Command(0x50);
    Write_Data(0x12);            // Gray Scale Level 37 of Red
    Write_Command(0x51);
    Write_Data(0x60);
    Write_Command(0x50);
    Write_Data(0x13);            // Gray Scale Level 39 of Red
    Write_Command(0x51);
    Write_Data(0x64);
    Write_Command(0x50);
    Write_Data(0x14);            // Gray Scale Level 41 of Red
    Write_Command(0x51);
    Write_Data(0x69);
    Write_Command(0x50);
    Write_Data(0x15);            // Gray Scale Level 43 of Red
    Write_Command(0x51);
    Write_Data(0x6B);
    Write_Command(0x50);
    Write_Data(0x16);            // Gray Scale Level 45 of Red
    Write_Command(0x51);
    Write_Data(0x6F);
    Write_Command(0x50);
    Write_Data(0x17);            // Gray Scale Level 47 of Red
    Write_Command(0x51);
    Write_Data(0x73);
    Write_Command(0x50);
    Write_Data(0x18);            // Gray Scale Level 49 of Red
    Write_Command(0x51);
    Write_Data(0x75);
    Write_Command(0x50);
    Write_Data(0x19);            // Gray Scale Level 51 of Red
    Write_Command(0x51);
    Write_Data(0x76);
    Write_Command(0x50);
    Write_Data(0x1A);            // Gray Scale Level 53 of Red
    Write_Command(0x51);
    Write_Data(0x77);
    Write_Command(0x50);
    Write_Data(0x1B);            // Gray Scale Level 55 of Red
    Write_Command(0x51);
    Write_Data(0x78);
    Write_Command(0x50);
    Write_Data(0x1C);            // Gray Scale Level 57 of Red
    Write_Command(0x51);
    Write_Data(0x7A);
    Write_Command(0x50);
    Write_Data(0x1D);            // Gray Scale Level 59 of Red
    Write_Command(0x51);
    Write_Data(0x7B);
    Write_Command(0x50);
    Write_Data(0x1E);            // Gray Scale Level 61 of Red
    Write_Command(0x51);
    Write_Data(0x7C);
    Write_Command(0x50);
    Write_Data(0x1F);            // Gray Scale Level 63 of Red
    Write_Command(0x51);
    Write_Data(0x7D);
    Write_Command(0x50);
    Write_Data(0x20);            // Gray Scale Level 1 of Green
    Write_Command(0x51);
    Write_Data(0x01);
    Write_Command(0x50);
    Write_Data(0x21);            // Gray Scale Level 3 of Green
    Write_Command(0x51);
    Write_Data(0x0F);
    Write_Command(0x50);
    Write_Data(0x22);            // Gray Scale Level 5 of Green
    Write_Command(0x51);
    Write_Data(0x16);
    Write_Command(0x50);
    Write_Data(0x23);            // Gray Scale Level 7 of Green
    Write_Command(0x51);
    Write_Data(0x1C);
    Write_Command(0x50);
    Write_Data(0x24);            // Gray Scale Level 9 of Green
    Write_Command(0x51);
    Write_Data(0x22);
    Write_Command(0x50);
    Write_Data(0x25);            // Gray Scale Level 11 of Green
    Write_Command(0x51);
    Write_Data(0x27);
    Write_Command(0x50);
    Write_Data(0x26);            // Gray Scale Level 13 of Green
    Write_Command(0x51);
    Write_Data(0x2C);
    Write_Command(0x50);
    Write_Data(0x27);            // Gray Scale Level 15 of Green
    Write_Command(0x51);
    Write_Data(0x32);
    Write_Command(0x50);
    Write_Data(0x28);            // Gray Scale Level 17 of Green
    Write_Command(0x51);
    Write_Data(0x37);
    Write_Command(0x50);
    Write_Data(0x29);            // Gray Scale Level 19 of Green
    Write_Command(0x51);
    Write_Data(0x3C);
    Write_Command(0x50);
    Write_Data(0x2A);            // Gray Scale Level 21 of Green
    Write_Command(0x51);
    Write_Data(0x41);
    Write_Command(0x50);
    Write_Data(0x2B);            // Gray Scale Level 23 of Green
    Write_Command(0x51);
    Write_Data(0x46);
    Write_Command(0x50);
    Write_Data(0x2C);            // Gray Scale Level 25 of Green
    Write_Command(0x51);
    Write_Data(0x4A);
    Write_Command(0x50);
    Write_Data(0x2D);            // Gray Scale Level 27 of Green
    Write_Command(0x51);
    Write_Data(0x4F);
    Write_Command(0x50);
    Write_Data(0x2E);            // Gray Scale Level 29 of Green
    Write_Command(0x51);
    Write_Data(0x53);
    Write_Command(0x50);
    Write_Data(0x2F);            // Gray Scale Level 31 of Green
    Write_Command(0x51);
    Write_Data(0x58);
    Write_Command(0x50);
    Write_Data(0x30);            // Gray Scale Level 33 of Green
    Write_Command(0x51);
    Write_Data(0x5B);
    Write_Command(0x50);
    Write_Data(0x31);            // Gray Scale Level 35 of Green
    Write_Command(0x51);
    Write_Data(0x60);
    Write_Command(0x50);
    Write_Data(0x32);            // Gray Scale Level 37 of Green
    Write_Command(0x51);
    Write_Data(0x64);
    Write_Command(0x50);
    Write_Data(0x33);            // Gray Scale Level 39 of Green
    Write_Command(0x51);
    Write_Data(0x67);
    Write_Command(0x50);
    Write_Data(0x34);            // Gray Scale Level 41 of Green
    Write_Command(0x51);
    Write_Data(0x6A);
    Write_Command(0x50);
    Write_Data(0x35);            // Gray Scale Level 43 of Green
    Write_Command(0x51);
    Write_Data(0x6D);
    Write_Command(0x50);
    Write_Data(0x36);            // Gray Scale Level 45 of Green
    Write_Command(0x51);
    Write_Data(0x6F);
    Write_Command(0x50);
    Write_Data(0x37);            // Gray Scale Level 47 of Green
    Write_Command(0x51);
    Write_Data(0x71);
    Write_Command(0x50);
    Write_Data(0x38);            // Gray Scale Level 49 of Green
    Write_Command(0x51);
    Write_Data(0x74);
    Write_Command(0x50);
    Write_Data(0x39);            // Gray Scale Level 51 of Green
    Write_Command(0x51);
    Write_Data(0x75);
    Write_Command(0x50);
    Write_Data(0x3A);            // Gray Scale Level 53 of Green
    Write_Command(0x51);
    Write_Data(0x77);
    Write_Command(0x50);
    Write_Data(0x3B);            // Gray Scale Level 55 of Green
    Write_Command(0x51);
    Write_Data(0x78);
    Write_Command(0x50);
    Write_Data(0x3C);            // Gray Scale Level 57 of Green
    Write_Command(0x51);
    Write_Data(0x79);
    Write_Command(0x50);
    Write_Data(0x3D);            // Gray Scale Level 59 of Green
    Write_Command(0x51);
    Write_Data(0x7A);
    Write_Command(0x50);
    Write_Data(0x3E);            // Gray Scale Level 61 of Green
    Write_Command(0x51);
    Write_Data(0x7B);
    Write_Command(0x50);
    Write_Data(0x3F);            // Gray Scale Level 63 of Green
    Write_Command(0x51);
    Write_Data(0x7D);
    Write_Command(0x50);
    Write_Data(0x40);            // Gray Scale Level 1 of Blue
    Write_Command(0x51);
    Write_Data(0x01);
    Write_Command(0x50);
    Write_Data(0x41);            // Gray Scale Level 3 of Blue
    Write_Command(0x51);
    Write_Data(0x21);
    Write_Command(0x50);
    Write_Data(0x42);            // Gray Scale Level 5 of Blue
    Write_Command(0x51);
    Write_Data(0x29);
    Write_Command(0x50);
    Write_Data(0x43);            // Gray Scale Level 7 of Blue
    Write_Command(0x51);
    Write_Data(0x30);
    Write_Command(0x50);
    Write_Data(0x44);            // Gray Scale Level 9 of Blue
    Write_Command(0x51);
    Write_Data(0x36);
    Write_Command(0x50);
    Write_Data(0x45);            // Gray Scale Level 11 of Blue
    Write_Command(0x51);
    Write_Data(0x3B);
    Write_Command(0x50);
    Write_Data(0x46);            // Gray Scale Level 13 of Blue
    Write_Command(0x51);
    Write_Data(0x41);
    Write_Command(0x50);
    Write_Data(0x47);            // Gray Scale Level 15 of Blue
    Write_Command(0x51);
    Write_Data(0x46);
    Write_Command(0x50);
    Write_Data(0x48);            // Gray Scale Level 17 of Blue
    Write_Command(0x51);
    Write_Data(0x4C);
    Write_Command(0x50);
    Write_Data(0x49);            // Gray Scale Level 19 of Blue
    Write_Command(0x51);
    Write_Data(0x51);
    Write_Command(0x50);
    Write_Data(0x4A);            // Gray Scale Level 21 of Blue
    Write_Command(0x51);
    Write_Data(0x55);
    Write_Command(0x50);
    Write_Data(0x4B);            // Gray Scale Level 23 of Blue
    Write_Command(0x51);
    Write_Data(0x5A);
    Write_Command(0x50);
    Write_Data(0x4C);            // Gray Scale Level 25 of Blue
    Write_Command(0x51);
    Write_Data(0x5E);
    Write_Command(0x50);
    Write_Data(0x4D);            // Gray Scale Level 27 of Blue
    Write_Command(0x51);
    Write_Data(0x62);
    Write_Command(0x50);
    Write_Data(0x4E);            // Gray Scale Level 29 of Blue
    Write_Command(0x51);
    Write_Data(0x65);
    Write_Command(0x50);
    Write_Data(0x4F);            // Gray Scale Level 31 of Blue
    Write_Command(0x51);
    Write_Data(0x69);
    Write_Command(0x50);
    Write_Data(0x50);            // Gray Scale Level 33 of Blue
    Write_Command(0x51);
    Write_Data(0x6B);
    Write_Command(0x50);
    Write_Data(0x51);            // Gray Scale Level 35 of Blue
    Write_Command(0x51);
    Write_Data(0x6E);
    Write_Command(0x50);
    Write_Data(0x52);            // Gray Scale Level 37 of Blue
    Write_Command(0x51);
    Write_Data(0x70);
    Write_Command(0x50);
    Write_Data(0x53);            // Gray Scale Level 39 of Blue
    Write_Command(0x51);
    Write_Data(0x72);
    Write_Command(0x50);
    Write_Data(0x54);            // Gray Scale Level 41 of Blue
    Write_Command(0x51);
    Write_Data(0x74);
    Write_Command(0x50);
    Write_Data(0x55);            // Gray Scale Level 43 of Blue
    Write_Command(0x51);
    Write_Data(0x75);
    Write_Command(0x50);
    Write_Data(0x56);            // Gray Scale Level 45 of Blue
    Write_Command(0x51);
    Write_Data(0x76);
    Write_Command(0x50);
    Write_Data(0x57);            // Gray Scale Level 47 of Blue
    Write_Command(0x51);
    Write_Data(0x77);
    Write_Command(0x50);
    Write_Data(0x58);            // Gray Scale Level 49 of Blue
    Write_Command(0x51);
    Write_Data(0x77);
    Write_Command(0x50);
    Write_Data(0x59);            // Gray Scale Level 51 of Blue
    Write_Command(0x51);
    Write_Data(0x78);
    Write_Command(0x50);
    Write_Data(0x5A);            // Gray Scale Level 53 of Blue
    Write_Command(0x51);
    Write_Data(0x79);
    Write_Command(0x50);
    Write_Data(0x5B);            // Gray Scale Level 55 of Blue
    Write_Command(0x51);
    Write_Data(0x7A);
    Write_Command(0x50);
    Write_Data(0x5C);            // Gray Scale Level 57 of Blue
    Write_Command(0x51);
    Write_Data(0x7B);
    Write_Command(0x50);
    Write_Data(0x5D);            // Gray Scale Level 59 of Blue
    Write_Command(0x51);
    Write_Data(0x7B);
    Write_Command(0x50);
    Write_Data(0x5E);            // Gray Scale Level 61 of Blue
    Write_Command(0x51);
    Write_Data(0x7C);
    Write_Command(0x50);
    Write_Data(0x5F);            // Gray Scale Level 63 of Blue
    Write_Command(0x51);
    Write_Data(0x7D);
}


//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//  Initialization
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void OLED_Init()
{
unsigned char i;

#if 0
    RES=0;
    for(i=0;i<200;i++)
    {
        uDelay(200);
    }
    RES=1;
#endif

    Set_Power_Save(0x01);            // Set Normal Driving Current
    uDelay(200);                //     Disable Oscillator Power Down
                        //     Enable Power Save Mode
    Set_Power_Save(0x00);            // Set Normal Driving Current
    uDelay(200);                //     Disable Oscillator Power Down
                        //     Disable Power Save Mode
    Software_Reset(0x00);            // Set All Internal Register Value as Normal Mode

    Set_Display_On_Off(0x00);        // Display Off (0x00/0x01)
    Set_Clock_Control(0x01);        // Set EXPORT1 Pin at Internal Clock
                        //     Oscillator operates with external resister.
                        //     Internal Oscillator On
    Set_Display_Clock(0x30);        // Set Clock as 90 Frames/Sec
    Set_Multiplex_Ratio(0x7F);        // 1/128 Duty (0x0F~0x7F)
    Set_Display_Offset(0x00,0x00);        // Shift Mapping RAM Counter
    Set_Start_Line(0x00);            // Set Mapping RAM Display Start Line (0x00~0x7F)
    Set_RGB_IF(0x31);            // Set MCU Interface Mode
    Set_RGB_POL(0x00);            // Set RGB Interface Polarity as Active Low
                        //     Dot Clock Polarity Sampled as Rising Edge
                        //     Disable Vertical Synchronization Output on VSYNCO Pin
    Set_Display_Mode(0x00);            // Set Color Sequence D[15:0]=[RRRRR:GGGGGG:BBBBB]
                        //     Alternative Gate Pin Configuration
                        //     Scan from G0 to G127
                        //     Column Address 0 Mapped to S0
                        //     One Screen Mode
                        //     Normal Display
    Set_Pixel_Format(0x66|((Color_Depth<<4)&0x70));
                        // Set Horizontal Address Increment
                        //     Vertical Address Increment
                        //     The data is continuously written horizontally.
                        //     Enable 8-bit Bus Interface
                        //     65,536 Colors Mode (0x66)
                        //     * 262,144 Colors Mode (0x76)
    Set_Driving_Current(0x2F,0x31,0x1E);    // Set Driving Current of Red
                        // Set Driving Current of Green
                        // Set Driving Current of Blue
    Set_Gray_Scale_Table();            // Set Pulse Width for Gamma Table
    Set_Precharge_Period(0x03,0x04,0x01);    // Set Pre-Charge Time of Red
                        // Set Pre-Charge Time of Green
                        // Set Pre-Charge Time of Blue
    Set_Precharge_Current(0x1A,0x19,0x0A);    // Set Pre-Charge Current of Red
                        // Set Pre-Charge Current of Green
                        // Set Pre-Charge Current of Blue
    Set_IREF(0x00);                // Set Reference Voltage Controlled by External Resister
    First_Screen(0x00,0x9F,0x00,0x7F);

    Fill_RAM(0x00,0x00);            // Clear Screen

    Set_Display_On_Off(0x01);        // Display On (0x00/0x01)
}

void OLED_Test(void)
{
    while (1) {

    // All Pixels On (Test Pattern)
        Fill_RAM(0xFF,0xFF);

    // Checkerboard (Test Pattern)
        Checkerboard();

        Rainbow();

    }
}

void RGB_IF_Init()
{
    Set_Display_On_Off(0x00);
    Set_RGB_POL(0x00);    // Set RGB Interface Polarity as Active Low
    Set_Pixel_Format(0x76);
    Set_Column_Address(0x00,0x9f);
    Set_Row_Address(0x04,0x7b);
    Set_Display_Offset(0x00,0x04);
    First_Screen(0x00,0x9F,0x04,0x7b);
    Set_Start_Line(0x00);     // Set Mapping RAM Display Start Line (0x00~0x7F)
    Set_Multiplex_Ratio(0x77);        // 1/128 Duty (0x0F~0x7F)
    Set_RGB_IF(0x20);
    Set_Display_On_Off(0x01);
    Set_Write_RAM();

/*
//  Amazingly, this isn't required; still works without it!
    ENABLE = 1;

    DOTCLK = 0;
    uDelay(10);
    DOTCLK = 1;

    VSYNC = 0;
    HSYNC = 0;

    DOTCLK = 0;
    uDelay(10);
    DOTCLK = 1;
    uDelay(10);
    DOTCLK = 0;
    uDelay(10);
    DOTCLK = 1;

    VSYNC = 1;
    HSYNC = 1;

    uDelay(10);
    DOTCLK = 0;
    uDelay(10);
    DOTCLK = 1;

    ENABLE = 0;
*/
}

void Sync_Frame(void)
{
    ENABLE = 1;

    DOTCLK = 0;
    asm{NOP};
    DOTCLK = 1;
    asm{NOP};

    VSYNC = 0;
    HSYNC = 0;

    DOTCLK = 0;
    asm{NOP};
    DOTCLK = 1;
    asm{NOP};
    DOTCLK = 0;
    asm{NOP};
    DOTCLK = 1;

    VSYNC = 1;
    HSYNC = 1;

    asm{NOP};
    DOTCLK = 0;

    ENABLE = 0;

    asm{NOP};
    DOTCLK = 1;

}

