

D2XXDevice::D2XXDevice()
{
	LoadDll();
}

D2XXDevice::~D2XXDevice()



//****************************************************************************************
bool D2XXDevice::LoadDLL()
{
	m_hmodule = LoadLibrary(TEXT("Ftd2xx.dll"));	
	if(m_hmodule == NULL)
	{
		return false;
	}

	m_pWrite = (PtrToWrite)GetProcAddress(m_hmodule, TEXT("FT_Write"));
	if (m_pWrite == NULL)
	{
		return false;
	}

	m_pRead = (PtrToRead)GetProcAddress(m_hmodule, TEXT("FT_Read"));
	if (m_pRead == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Read"));
		return false;
	}

	m_pOpen = (PtrToOpen)GetProcAddress(m_hmodule, TEXT("FT_Open"));
	if (m_pOpen == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Open"));
		return false;
	}

	m_pOpenEx = (PtrToOpenEx)GetProcAddress(m_hmodule, TEXT("FT_OpenEx"));
	if (m_pOpenEx == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_OpenEx"));
		return false;
	}

	m_pListDevices = (PtrToListDevices)GetProcAddress(m_hmodule, TEXT("FT_ListDevices"));
	if(m_pListDevices == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ListDevices"));
		return false;
	}

	m_pClose = (PtrToClose)GetProcAddress(m_hmodule, TEXT("FT_Close"));
	if (m_pClose == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Close"));
		return false;
	}

	m_pResetDevice = (PtrToResetDevice)GetProcAddress(m_hmodule, TEXT("FT_ResetDevice"));
	if (m_pResetDevice == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ResetDevice"));
		return false;
	}

	m_pPurge = (PtrToPurge)GetProcAddress(m_hmodule, TEXT("FT_Purge"));
	if (m_pPurge == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Purge"));
		return false;
	}

	m_pSetTimeouts = (PtrToSetTimeouts)GetProcAddress(m_hmodule, TEXT("FT_SetTimeouts"));
	if (m_pSetTimeouts == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetTimeouts"));
		return false;
	}

	m_pGetQueueStatus = (PtrToGetQueueStatus)GetProcAddress(m_hmodule, TEXT("FT_GetQueueStatus"));
	if (m_pGetQueueStatus == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetQueueStatus"));
		return false;
	}

	m_pSetDtr = (PtrToSetDtr)GetProcAddress(m_hmodule, TEXT("FT_SetDtr"));
	if (m_pSetDtr == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetDtr"));
		return false;
	}

	m_pClrDtr = (PtrToClrDtr)GetProcAddress(m_hmodule, TEXT("FT_ClrDtr"));
	if (m_pClrDtr == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ClrDtr"));
		return false;
	}
	
	m_pSetRts = (PtrToSetRts)GetProcAddress(m_hmodule, TEXT("FT_SetRts"));
	if (m_pSetRts == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetRts"));
		return false;
	}
	
	m_pClrRts = (PtrToClrRts)GetProcAddress(m_hmodule, TEXT("FT_ClrRts"));
	if (m_pClrRts == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ClrRts"));
		return false;
	}

	m_pGetModemStatus = (PtrToGetModemStatus)GetProcAddress(m_hmodule, TEXT("FT_GetModemStatus"));
	if (m_pGetModemStatus == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetModemStatus"));
		return false;
	}

	m_pSetChars = (PtrToSetChars)GetProcAddress(m_hmodule, TEXT("FT_SetChars"));
	if (m_pSetChars == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetChars"));
		return false;
	}
	
	m_pSetLatencyTimer = (PtrToSetLatencyTimer)GetProcAddress(m_hmodule, TEXT("FT_SetLatencyTimer"));
	if (m_pSetLatencyTimer == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetLatencyTimer"));
		return false;
	}

	
	m_pGetLatencyTimer = (PtrToGetLatencyTimer)GetProcAddress(m_hmodule, TEXT("FT_GetLatencyTimer"));
	if (m_pGetLatencyTimer == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetLatencyTimer"));
		return false;
	}

	
	m_pSetDataCharacteristics = (PtrToSetDataCharacteristics)GetProcAddress(m_hmodule, TEXT("FT_SetDataCharacteristics"));
	if (m_pSetDataCharacteristics == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetDataCharacteristics"));
		return false;
	}

	
	m_pSetFlowControl = (PtrToSetFlowControl)GetProcAddress(m_hmodule, TEXT("FT_SetFlowControl"));
	if (m_pSetFlowControl == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetFlowControl"));
		return false;
	}

	
	m_pSetBreakOn = (PtrToSetBreakOn)GetProcAddress(m_hmodule, TEXT("FT_SetBreakOn"));
	if (m_pSetBreakOn == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetBreakOn"));
		return false;
	}	

	
	m_pSetBreakOff = (PtrToSetBreakOff)GetProcAddress(m_hmodule, TEXT("FT_SetBreakOff"));
	if (m_pSetBreakOff == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetBreakOff"));
		return false;
	}

	
	m_pResetPort = (PtrToResetPort)GetProcAddress(m_hmodule, TEXT("FT_ResetPort"));
	if (m_pResetPort == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ResetPort"));
		return false;
	}

	
	m_pGetDeviceInfo = (PtrToGetDeviceInfo)GetProcAddress(m_hmodule, TEXT("FT_GetDeviceInfo"));
	if (m_pGetDeviceInfo == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetDeviceInfo"));
		return false;
	}

	
	m_pEE_UASize = (PtrToEE_UASize)GetProcAddress(m_hmodule, TEXT("FT_EE_UASize"));
	if (m_pEE_UASize == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_EE_UASize"));
		return false;
	}

	
	m_pEE_UARead = (PtrToEE_UARead)GetProcAddress(m_hmodule, TEXT("FT_EE_UARead"));
	if (m_pEE_UARead == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_EE_UARead"));
		return false;
	}

	
	m_pEE_UAWrite = (PtrToEE_UAWrite)GetProcAddress(m_hmodule, TEXT("FT_EE_UAWrite"));
	if (m_pEE_UAWrite == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_EE_UAWrite"));
		return false;
	}

	
	m_pSetBitMode = (PtrToSetBitMode)GetProcAddress(m_hmodule, TEXT("FT_SetBitMode"));
	if (m_pSetBitMode == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetBitMode"));
		return false;
	}
	
	m_pGetBitMode = (PtrToGetBitMode)GetProcAddress(m_hmodule, TEXT("FT_GetBitMode"));
	if (m_pGetBitMode == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetBitMode"));
		return false;
	}
	
	m_pSetEventNotification = (PtrToSetEventNotification)GetProcAddress(m_hmodule, TEXT("FT_SetEventNotification"));
	if (m_pSetEventNotification == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetEventNotification"));
		return false;
	}
	
	m_pGetStatus = (PtrToGetStatus)GetProcAddress(m_hmodule, TEXT("FT_GetStatus"));
	if (m_pGetStatus == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetStatus"));
		return false;
	}
	
	m_pGetEventStatus = (PtrToGetEventStatus)GetProcAddress(m_hmodule, TEXT("FT_GetEventStatus"));
	if (m_pGetEventStatus == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetEventStatus"));
		return false;
	}
	
	m_pSetBaudRate = (PtrToSetBaudRate)GetProcAddress(m_hmodule, TEXT("FT_SetBaudRate"));
	if (m_pSetBaudRate == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetBaudRate"));
		return false;
	}
}

//****************************************************************************************
FT_STATUS D2XXDevice::Read(LPVOID lpvBuffer, DWORD dwBuffSize, LPDWORD lpdwBytesRead)
{
	DWORD BytesAvail = 0;

	if (!m_pRead)
	{
		return FT_INVALID_HANDLE;
	}

	return (*m_pRead)(m_ftHandle, lpvBuffer, dwBuffSize, lpdwBytesRead);
}	


//****************************************************************************************
FT_STATUS D2XXDevice::Write(LPVOID lpvBuffer, DWORD dwBuffSize, LPDWORD lpdwBytes)
{
	if (!m_pWrite)
	{
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pWrite)(m_ftHandle, lpvBuffer, dwBuffSize, lpdwBytes);
}


//****************************************************************************************
FT_STATUS D2XXDevice::Open(PVOID pvDevice)
{
	if (!m_pOpen)
	{
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pOpen)(pvDevice, &m_ftHandle );
}	

//****************************************************************************************
FT_STATUS D2XXDevice::OpenEx(PVOID pArg1, DWORD dwFlags)
{
	if (!m_pOpenEx)
	{
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pOpenEx)(pArg1, dwFlags, &m_ftHandle);
}	


//****************************************************************************************
FT_STATUS D2XXDevice::ListDevices(PVOID pArg1, PVOID pArg2, DWORD dwFlags)
{
	if (!m_pListDevices)
	{
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pListDevices)(pArg1, pArg2, dwFlags);
}	


//****************************************************************************************
FT_STATUS D2XXDevice::Close()
{
	FT_STATUS status;
	if (!m_pClose)
	{
		return FT_INVALID_HANDLE;
	}
	
	status = (*m_pClose)(m_ftHandle);
	m_ftHandle = NULL;
	return status;
}	



//****************************************************************************************
FT_STATUS D2XXDevice::ResetDevice()
{
	if (!m_pResetDevice)
	{
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pResetDevice)(m_ftHandle);
}	



//****************************************************************************************
FT_STATUS D2XXDevice::Purge(ULONG dwMask)
{
	if (!m_pPurge)
	{
		return FT_INVALID_HANDLE;
	}

	return (*m_pPurge)(m_ftHandle, dwMask);
}	



//****************************************************************************************
FT_STATUS D2XXDevice::SetTimeouts(ULONG dwReadTimeout, ULONG dwWriteTimeout)
{
	if (!m_pSetTimeouts)
	{
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetTimeouts)(m_ftHandle, dwReadTimeout, dwWriteTimeout);
}	



//****************************************************************************************
FT_STATUS D2XXDevice::GetQueueStatus(LPDWORD lpdwAmountInRxQueue)
{
	if (!m_pGetQueueStatus)
	{
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetQueueStatus)(m_ftHandle, lpdwAmountInRxQueue);
}



//****************************************************************************************
FT_STATUS D2XXDevice::SetDtr()
{
	if (!m_pSetDtr)
	{
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetDtr)(m_ftHandle);
}	


//****************************************************************************************
FT_STATUS D2XXDevice::ClrDtr()
{
	if (!m_pClrDtr)
	{
		return FT_INVALID_HANDLE;
	}

	return (*m_pClrDtr)(m_ftHandle);
}



//****************************************************************************************
FT_STATUS D2XXDevice::SetRts()
{
	if (!m_pSetRts)
	{
		AfxMessageBox(TEXT("FT_SetRts is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetRts)(m_ftHandle);
}


//****************************************************************************************
FT_STATUS D2XXDevice::ClrRts()
{
	if (!m_pClrRts)
	{
		AfxMessageBox(TEXT("FT_ClrRts is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pClrRts)(m_ftHandle);
}


//****************************************************************************************
FT_STATUS D2XXDevice::GetModemStatus(LPDWORD lpdwModemStatus)
{
	if (!m_pGetModemStatus)
	{
		AfxMessageBox(TEXT("FT_GetModemStatus is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetModemStatus)(m_ftHandle, lpdwModemStatus);
}


//****************************************************************************************
FT_STATUS D2XXDevice::SetLatencyTimer(UCHAR ucLatencyTimer)
{
	if (!m_pSetLatencyTimer)
	{
		AfxMessageBox(TEXT("FT_SetLatencyTimer is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetLatencyTimer)(m_ftHandle, ucLatencyTimer);
}


//****************************************************************************************
FT_STATUS D2XXDevice::GetLatencyTimer(PUCHAR pucLatencyTimer)
{
	if (!m_pGetLatencyTimer)
	{
		AfxMessageBox(TEXT("FT_GetLatencyTimer is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetLatencyTimer)(m_ftHandle, pucLatencyTimer);
}


//****************************************************************************************
FT_STATUS D2XXDevice::SetDataCharacteristics(UCHAR uWordLength, UCHAR uStopBits, UCHAR uParity)
{
	if (!m_pSetDataCharacteristics)
	{
		AfxMessageBox(TEXT("FT_SetDataCharacteristics is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetDataCharacteristics)(m_ftHandle, uWordLength, uStopBits, uParity);
}



//****************************************************************************************
FT_STATUS D2XXDevice::SetChars(UCHAR uEventCh, UCHAR uEventChEn, UCHAR uErrorCh, UCHAR uErrorChEn)
{
	if (!m_pSetChars)
	{
		AfxMessageBox(TEXT("FT_SetChars is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetChars)(m_ftHandle, uEventCh, uEventChEn, uErrorCh, uErrorChEn);
}


//****************************************************************************************
FT_STATUS D2XXDevice::SetFlowControl(USHORT usFlowControl, UCHAR uXon, UCHAR uXoff)
{
	if (!m_pSetFlowControl)
	{
		AfxMessageBox(TEXT("FT_SetFlowControl is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetFlowControl)(m_ftHandle, usFlowControl, uXon, uXoff);
}


//****************************************************************************************
FT_STATUS D2XXDevice::SetBreakOn()
{
	if (!m_pSetBreakOn)
	{
		AfxMessageBox(TEXT("FT_SetBreakOn is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBreakOn)(m_ftHandle);
}


//****************************************************************************************
FT_STATUS D2XXDevice::SetBreakOff()
{
	if (!m_pSetBreakOff)
	{
		AfxMessageBox(TEXT("FT_SetBreakOff is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBreakOff)(m_ftHandle);
}


//****************************************************************************************
FT_STATUS D2XXDevice::ResetPort()
{
	if (!m_pResetPort)
	{
		AfxMessageBox(TEXT("FT_ResetPort is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pResetPort)(m_ftHandle);
}


//****************************************************************************************
FT_STATUS D2XXDevice::GetDeviceInfo(FT_DEVICE * lpftDevice, LPDWORD lpdwID, PCHAR pcSerialNumber, PCHAR pcDescription, LPVOID lpDummy)
{
	if (!m_pGetDeviceInfo)
	{
		AfxMessageBox(TEXT("FT_GetDeviceInfo is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetDeviceInfo)(m_ftHandle, lpftDevice, lpdwID, pcSerialNumber, pcDescription, lpDummy);
}


	
//****************************************************************************************
FT_STATUS D2XXDevice::EE_UASize(LPDWORD lpdwSize)
{
	if (!m_pEE_UASize)
	{
		AfxMessageBox(TEXT("FT_EE_UASize is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pEE_UASize)(m_ftHandle,  lpdwSize);
}	

	

//****************************************************************************************
FT_STATUS D2XXDevice::EE_UARead(PUCHAR pucData, DWORD dwDataLen, LPDWORD lpdwBytesRead)
{
	if (!m_pEE_UARead)
	{
		AfxMessageBox(TEXT("FT_EE_UARead is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pEE_UARead)(m_ftHandle, pucData, dwDataLen, lpdwBytesRead);
}	

	

//****************************************************************************************
FT_STATUS D2XXDevice::EE_UAWrite(PUCHAR pucData, DWORD dwDataLen)
{
	if (!m_pEE_UAWrite)
	{
		AfxMessageBox(TEXT("FT_EE_UAWrite is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pEE_UAWrite)(m_ftHandle, pucData, dwDataLen);
}


//****************************************************************************************
FT_STATUS D2XXDevice::SetBitMode(UCHAR ucMask, UCHAR ucEnable)
{
	if (!m_pSetBitMode)
	{
		AfxMessageBox(TEXT("FT_SetBitMode is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBitMode)(m_ftHandle, ucMask, ucEnable);
}


//****************************************************************************************
FT_STATUS D2XXDevice::GetBitMode(PUCHAR pucMode)
{
	if (!m_pGetBitMode)
	{
		AfxMessageBox(TEXT("FT_GetBitMode is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetBitMode)(m_ftHandle, pucMode);
}


//****************************************************************************************
FT_STATUS D2XXDevice::SetEventNotification(DWORD dwEventMask, PVOID pvArg)
{
	if (!m_pSetEventNotification)
	{
		AfxMessageBox(TEXT("FT_SetEventNotification is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetEventNotification)(m_ftHandle, dwEventMask, pvArg);
}


//****************************************************************************************
FT_STATUS D2XXDevice::GetStatus(LPDWORD lpdwAmountInRxQueue, LPDWORD lpdwAmountInTxQueue, LPDWORD lpdwEventStatus )
{
	if (!m_pGetStatus)
	{
		AfxMessageBox(TEXT("FT_GetStatus is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetStatus)(m_ftHandle, lpdwAmountInRxQueue, lpdwAmountInTxQueue, lpdwEventStatus);
}


//****************************************************************************************
FT_STATUS D2XXDevice::GetEventStatus(LPDWORD lpdwEventStatus)
{
	if (!m_pGetEventStatus)
	{
		AfxMessageBox(TEXT("FT_GetEventStatus is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetEventStatus)(m_ftHandle, lpdwEventStatus);
}	


//****************************************************************************************
FT_STATUS D2XXDevice::SetBaudRate(DWORD dwBaudRate)
{
	if (!m_pSetBaudRate)
	{
		AfxMessageBox(TEXT("FT_SetBaudRate is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBaudRate)(m_ftHandle, dwBaudRate);
}	

