// D2XXAccessDlg.h : header file
//

#if !defined(AFX_D2XXACCESSDLG_H__80FDF19B_47A8_40B4_A04F_7699028CA23A__INCLUDED_)
#define AFX_D2XXACCESSDLG_H__80FDF19B_47A8_40B4_A04F_7699028CA23A__INCLUDED_

#include "ftd2xx.h"

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
#include "resource.h"

#define COM_BUF_SIZE	256

typedef struct ComBuffer {
	char cBuf[COM_BUF_SIZE];
	int size;
} COMBUFFER, *PCOMBUFFER;

#define TEXTSIZE 256

/////////////////////////////////////////////////////////////////////////////
// CD2XXAccessDlg dialog

class CD2XXAccessDlg : public CDialog
{
// Construction
public:
	BOOL ReadRunning;
	BOOL WriteRunning;
	HMODULE m_hmodule;
	DWORD dwListDescFlags;
	BOOL ListUnopenDevices(INT iDlgID);
	CWinThread * pThreadRead;
	CWinThread * pThreadWrite;
	CWinThread * pThreadNotify;
	void SetUpDevList(INT iDlgID);
	BOOL ClosePort(BOOL bSetButtons);
	BOOL OpenPort(BOOL bStartThreads);
	FT_HANDLE m_hPort;
	HANDLE m_hEventWrite;
	HANDLE m_hEventClose;
	HANDLE m_ReplugEvent;
	COMBUFFER sWriteBuffer;
	BOOL fContinue;
	CD2XXAccessDlg(CWnd* pParent = NULL);	// standard constructor
	void CreateGUIDKey();

	void LoadDLL();

	typedef FT_STATUS (WINAPI *PtrToOpen)(PVOID, FT_HANDLE *); 
	PtrToOpen m_pOpen; 
	FT_STATUS Open(PVOID);

	typedef FT_STATUS (WINAPI *PtrToOpenEx)(PVOID, DWORD, FT_HANDLE *); 
	PtrToOpenEx m_pOpenEx; 
	FT_STATUS OpenEx(PVOID, DWORD);

	typedef FT_STATUS (WINAPI *PtrToListDevices)(PVOID, PVOID, DWORD);
	PtrToListDevices m_pListDevices; 
	FT_STATUS ListDevices(PVOID, PVOID, DWORD);

	typedef FT_STATUS (WINAPI *PtrToClose)(FT_HANDLE);
	PtrToClose m_pClose;
	FT_STATUS Close();

	typedef FT_STATUS (WINAPI *PtrToRead)(FT_HANDLE, LPVOID, DWORD, LPDWORD);
	PtrToRead m_pRead;
	FT_STATUS Read(LPVOID, DWORD, LPDWORD);

	typedef FT_STATUS (WINAPI *PtrToWrite)(FT_HANDLE, LPVOID, DWORD, LPDWORD);
	PtrToWrite m_pWrite;
	FT_STATUS Write(LPVOID, DWORD, LPDWORD);

	typedef FT_STATUS (WINAPI *PtrToResetDevice)(FT_HANDLE);
	PtrToResetDevice m_pResetDevice;
	FT_STATUS ResetDevice();
	
	typedef FT_STATUS (WINAPI *PtrToPurge)(FT_HANDLE, ULONG);
	PtrToPurge m_pPurge;
	FT_STATUS Purge(ULONG);
	
	typedef FT_STATUS (WINAPI *PtrToSetTimeouts)(FT_HANDLE, ULONG, ULONG);
	PtrToSetTimeouts m_pSetTimeouts;
	FT_STATUS SetTimeouts(ULONG, ULONG);

	typedef FT_STATUS (WINAPI *PtrToGetQueueStatus)(FT_HANDLE, LPDWORD);
	PtrToGetQueueStatus m_pGetQueueStatus;
	FT_STATUS GetQueueStatus(LPDWORD);

	typedef FT_STATUS (WINAPI *PtrToSetDtr)(FT_HANDLE);
	PtrToSetDtr m_pSetDtr;
	FT_STATUS SetDtr();

	typedef FT_STATUS (WINAPI *PtrToClrDtr)(FT_HANDLE);
	PtrToClrDtr m_pClrDtr;
	FT_STATUS ClrDtr();

	typedef FT_STATUS (WINAPI *PtrToSetRts)(FT_HANDLE);
	PtrToSetRts m_pSetRts;
	FT_STATUS SetRts();

	typedef FT_STATUS (WINAPI *PtrToClrRts)(FT_HANDLE);
	PtrToClrRts m_pClrRts;
	FT_STATUS ClrRts();

	typedef FT_STATUS (WINAPI *PtrToGetModemStatus)(FT_HANDLE, LPDWORD);
	PtrToGetModemStatus m_pGetModemStatus;
	FT_STATUS GetModemStatus(LPDWORD);

	typedef FT_STATUS (WINAPI *PtrToSetChars)(FT_HANDLE, UCHAR, UCHAR, UCHAR, UCHAR);
	PtrToSetChars m_pSetChars;
	FT_STATUS SetChars(UCHAR, UCHAR, UCHAR, UCHAR);

	typedef FT_STATUS (WINAPI *PtrToSetLatencyTimer)(FT_HANDLE, UCHAR);
	PtrToSetLatencyTimer m_pSetLatencyTimer;
	FT_STATUS SetLatencyTimer(UCHAR);

	typedef FT_STATUS (WINAPI *PtrToGetLatencyTimer)(FT_HANDLE, PUCHAR);
	PtrToGetLatencyTimer m_pGetLatencyTimer;
	FT_STATUS GetLatencyTimer(PUCHAR);

	typedef FT_STATUS (WINAPI *PtrToSetDataCharacteristics)(FT_HANDLE, UCHAR, UCHAR, UCHAR);
	PtrToSetDataCharacteristics m_pSetDataCharacteristics;
	FT_STATUS SetDataCharacteristics(UCHAR, UCHAR, UCHAR);

	typedef FT_STATUS (WINAPI *PtrToSetFlowControl)(FT_HANDLE, USHORT, UCHAR, UCHAR);
	PtrToSetFlowControl m_pSetFlowControl;
	FT_STATUS SetFlowControl(USHORT, UCHAR, UCHAR);

	typedef FT_STATUS (WINAPI *PtrToSetBreakOn)(FT_HANDLE);
	PtrToSetBreakOn m_pSetBreakOn;
	FT_STATUS SetBreakOn();

	typedef FT_STATUS (WINAPI *PtrToSetBreakOff)(FT_HANDLE);
	PtrToSetBreakOff m_pSetBreakOff;
	FT_STATUS SetBreakOff();

	typedef FT_STATUS (WINAPI *PtrToResetPort)(FT_HANDLE);
	PtrToResetPort m_pResetPort;
	FT_STATUS ResetPort();

	typedef FT_STATUS (WINAPI *PtrToGetDeviceInfo)(FT_HANDLE, FT_DEVICE *, LPDWORD, PCHAR, PCHAR, LPVOID);
	PtrToGetDeviceInfo m_pGetDeviceInfo;
	FT_STATUS GetDeviceInfo(FT_DEVICE *, LPDWORD, PCHAR, PCHAR, LPVOID);

	typedef FT_STATUS (WINAPI *PtrToEE_UASize)(FT_HANDLE, LPDWORD);
	PtrToEE_UASize m_pEE_UASize;
	FT_STATUS EE_UASize(LPDWORD);

	typedef FT_STATUS (WINAPI *PtrToEE_UARead)(FT_HANDLE, PUCHAR, DWORD, LPDWORD);
	PtrToEE_UARead m_pEE_UARead;
	FT_STATUS EE_UARead(PUCHAR, DWORD, LPDWORD);

	typedef FT_STATUS (WINAPI *PtrToEE_UAWrite)(FT_HANDLE, PUCHAR, DWORD);
	PtrToEE_UAWrite m_pEE_UAWrite;
	FT_STATUS EE_UAWrite(PUCHAR, DWORD);

	typedef FT_STATUS (WINAPI *PtrToSetBitMode)(FT_HANDLE, UCHAR, UCHAR);
	PtrToSetBitMode m_pSetBitMode;
	FT_STATUS SetBitMode(UCHAR, UCHAR);	

	typedef FT_STATUS (WINAPI *PtrToGetBitMode)(FT_HANDLE, PUCHAR);
	PtrToGetBitMode m_pGetBitMode;
	FT_STATUS GetBitMode(PUCHAR);

	typedef FT_STATUS (WINAPI *PtrToSetEventNotification)(FT_HANDLE, DWORD, PVOID);
	PtrToSetEventNotification m_pSetEventNotification;
	FT_STATUS SetEventNotification(DWORD, PVOID);

	typedef FT_STATUS (WINAPI *PtrToGetStatus)(FT_HANDLE, LPDWORD, LPDWORD, LPDWORD);
	PtrToGetStatus m_pGetStatus;
	FT_STATUS GetStatus(LPDWORD, LPDWORD, LPDWORD);	

	typedef FT_STATUS (WINAPI *PtrToGetEventStatus)(FT_HANDLE, LPDWORD);
	PtrToGetEventStatus m_pGetEventStatus;
	FT_STATUS GetEventStatus(LPDWORD);	

	typedef FT_STATUS (WINAPI *PtrToSetBaudRate)(FT_HANDLE, DWORD);
	PtrToSetBaudRate m_pSetBaudRate;
	FT_STATUS SetBaudRate(DWORD);
	
	typedef FT_STATUS (WINAPI *PtrToGetDriverVersion)(FT_HANDLE, LPDWORD);
	PtrToGetDriverVersion m_pGetDriverVersion;
	FT_STATUS GetDriverVersion(LPDWORD);	

	typedef FT_STATUS (WINAPI *PtrToGetLibraryVersion)(LPDWORD);
	PtrToGetLibraryVersion m_pGetLibraryVersion;
	FT_STATUS GetLibraryVersion(LPDWORD);
	
// Dialog Data
	//{{AFX_DATA(CD2XXAccessDlg)
	enum { IDD = IDD_D2XXACCESS_DIALOG };
	CListBox	m_ReadList;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CD2XXAccessDlg)
	public:
	virtual BOOL DestroyWindow();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CD2XXAccessDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnClose();
	afx_msg void OnOpen();
	afx_msg void OnWrite();
	afx_msg void OnDestroy();
	afx_msg void OnDescription();
	afx_msg void OnNumber();
	afx_msg void OnSerial();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft eMbedded Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_D2XXACCESSDLG_H__80FDF19B_47A8_40B4_A04F_7699028CA23A__INCLUDED_)
