// D2XXAccessDlg.cpp : implementation file
//

#include "stdafx.h"
#include "D2XXAccess.h"
#include "D2XXAccessDlg.h"
#include "D2XXModule.h"
#include <pnp.h>
#include <msgqueue.h>
#include <pm.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define READ_THREAD_WAIT_TIMEOUT	5000
#define WRITE_THREAD_WAIT_TIMEOUT	5000

UINT SendThread (LPVOID pArg);
UINT ReadThread (LPVOID pArg);

typedef union {
  DEVDETAIL d;
  char pad[sizeof(DEVDETAIL)+MAX_DEVCLASS_NAMELEN];
} MYDEV;

// If you want this application to work and notify with device plug you must insert the following
// GUID into the registry for the driver under \\HKLM\Drivers\USB\FTDI_XXXX\IClass as a string type
// this is currently not supported in the INF setup but a simple application can be written to insert this
// if you have no access to a registry editor
const TCHAR g_GUID[] = L"{297B9B00-16E4-46df-83B2-08227D9335AC}";

/////////////////////////////////////////////////////////////////////////////
// CD2XXAccessDlg dialog

CD2XXAccessDlg::CD2XXAccessDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CD2XXAccessDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CD2XXAccessDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CD2XXAccessDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CD2XXAccessDlg)
	DDX_Control(pDX, IDC_READ_LIST, m_ReadList);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CD2XXAccessDlg, CDialog)
	//{{AFX_MSG_MAP(CD2XXAccessDlg)
	ON_BN_CLICKED(IDC_CLOSE, OnClose)
	ON_BN_CLICKED(IDC_OPEN, OnOpen)
	ON_BN_CLICKED(IDC_WRITE, OnWrite)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_DESCRIPTION, OnDescription)
	ON_BN_CLICKED(IDC_NUMBER, OnNumber)
	ON_BN_CLICKED(IDC_SERIAL, OnSerial)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CD2XXAccessDlg message handlers

BOOL CD2XXAccessDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CString str;
	DWORD dwDllVersion;
	FT_STATUS ftStatus;

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	CenterWindow(GetDesktopWindow());	// center to the hpc screen
	LoadDLL();
	m_hPort = NULL;
	fContinue = TRUE;
	sWriteBuffer.size = COM_BUF_SIZE;
	dwListDescFlags = FT_LIST_ALL;

	str.Format(L"%d", COM_BUF_SIZE);
	SetDlgItemText(IDC_WRITE_COUNT, str);
	SetUpDevList(IDC_CMB_PORTS);

	GetDlgItem(IDC_CLOSE)->EnableWindow(FALSE);
	GetDlgItem(IDC_OPEN)->EnableWindow(TRUE);
	GetDlgItem(IDC_WRITE)->EnableWindow(FALSE);

	SendDlgItemMessage (IDC_NUMBER, BM_SETCHECK, 1, 0);

	ftStatus = GetLibraryVersion(&dwDllVersion);

	if(ftStatus == FT_OK) {
		CString str;

		str.Format(L"%d.%d.%d.%d", 
			(int)((char)((dwDllVersion & 0xFF000000) >> 24)),
			(int)((char)((dwDllVersion & 0x00FF0000) >> 16)),
			(int)((char)((dwDllVersion & 0x0000FF00) >> 8)),
			(int)((char)((dwDllVersion & 0x000000FF))));

		SetDlgItemText(IDC_DLL_VERSION, str);
	}
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

//****************************************************************************************
void CD2XXAccessDlg::LoadDLL()
{
	m_hmodule = LoadLibrary(TEXT("Ftd2xx.dll"));	
	if(m_hmodule == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Load ftd2xx.dll"));
		return;
	}

	m_pWrite = (PtrToWrite)GetProcAddress(m_hmodule, TEXT("FT_Write"));
	if (m_pWrite == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Write"));
		return;
	}

	m_pRead = (PtrToRead)GetProcAddress(m_hmodule, TEXT("FT_Read"));
	if (m_pRead == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Read"));
		return;
	}

	m_pOpen = (PtrToOpen)GetProcAddress(m_hmodule, TEXT("FT_Open"));
	if (m_pOpen == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Open"));
		return;
	}

	m_pOpenEx = (PtrToOpenEx)GetProcAddress(m_hmodule, TEXT("FT_OpenEx"));
	if (m_pOpenEx == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_OpenEx"));
		return;
	}

	m_pListDevices = (PtrToListDevices)GetProcAddress(m_hmodule, TEXT("FT_ListDevices"));
	if(m_pListDevices == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ListDevices"));
		return;
	}

	m_pClose = (PtrToClose)GetProcAddress(m_hmodule, TEXT("FT_Close"));
	if (m_pClose == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Close"));
		return;
	}

	m_pResetDevice = (PtrToResetDevice)GetProcAddress(m_hmodule, TEXT("FT_ResetDevice"));
	if (m_pResetDevice == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ResetDevice"));
		return;
	}

	m_pPurge = (PtrToPurge)GetProcAddress(m_hmodule, TEXT("FT_Purge"));
	if (m_pPurge == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_Purge"));
		return;
	}

	m_pSetTimeouts = (PtrToSetTimeouts)GetProcAddress(m_hmodule, TEXT("FT_SetTimeouts"));
	if (m_pSetTimeouts == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetTimeouts"));
		return;
	}

	m_pGetQueueStatus = (PtrToGetQueueStatus)GetProcAddress(m_hmodule, TEXT("FT_GetQueueStatus"));
	if (m_pGetQueueStatus == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetQueueStatus"));
		return;
	}

	m_pSetDtr = (PtrToSetDtr)GetProcAddress(m_hmodule, TEXT("FT_SetDtr"));
	if (m_pSetDtr == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetDtr"));
		return;
	}

	m_pClrDtr = (PtrToClrDtr)GetProcAddress(m_hmodule, TEXT("FT_ClrDtr"));
	if (m_pClrDtr == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ClrDtr"));
		return;
	}
	
	m_pSetRts = (PtrToSetRts)GetProcAddress(m_hmodule, TEXT("FT_SetRts"));
	if (m_pSetRts == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetRts"));
		return;
	}
	
	m_pClrRts = (PtrToClrRts)GetProcAddress(m_hmodule, TEXT("FT_ClrRts"));
	if (m_pClrRts == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ClrRts"));
		return;
	}

	m_pGetModemStatus = (PtrToGetModemStatus)GetProcAddress(m_hmodule, TEXT("FT_GetModemStatus"));
	if (m_pGetModemStatus == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetModemStatus"));
		return;
	}

	m_pSetChars = (PtrToSetChars)GetProcAddress(m_hmodule, TEXT("FT_SetChars"));
	if (m_pSetChars == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetChars"));
		return;
	}
	
	m_pSetLatencyTimer = (PtrToSetLatencyTimer)GetProcAddress(m_hmodule, TEXT("FT_SetLatencyTimer"));
	if (m_pSetLatencyTimer == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetLatencyTimer"));
		return;
	}

	
	m_pGetLatencyTimer = (PtrToGetLatencyTimer)GetProcAddress(m_hmodule, TEXT("FT_GetLatencyTimer"));
	if (m_pGetLatencyTimer == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetLatencyTimer"));
		return;
	}

	
	m_pSetDataCharacteristics = (PtrToSetDataCharacteristics)GetProcAddress(m_hmodule, TEXT("FT_SetDataCharacteristics"));
	if (m_pSetDataCharacteristics == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetDataCharacteristics"));
		return;
	}

	
	m_pSetFlowControl = (PtrToSetFlowControl)GetProcAddress(m_hmodule, TEXT("FT_SetFlowControl"));
	if (m_pSetFlowControl == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetFlowControl"));
		return;
	}

	
	m_pSetBreakOn = (PtrToSetBreakOn)GetProcAddress(m_hmodule, TEXT("FT_SetBreakOn"));
	if (m_pSetBreakOn == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetBreakOn"));
		return;
	}	

	
	m_pSetBreakOff = (PtrToSetBreakOff)GetProcAddress(m_hmodule, TEXT("FT_SetBreakOff"));
	if (m_pSetBreakOff == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetBreakOff"));
		return;
	}

	
	m_pResetPort = (PtrToResetPort)GetProcAddress(m_hmodule, TEXT("FT_ResetPort"));
	if (m_pResetPort == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_ResetPort"));
		return;
	}

	
	m_pGetDeviceInfo = (PtrToGetDeviceInfo)GetProcAddress(m_hmodule, TEXT("FT_GetDeviceInfo"));
	if (m_pGetDeviceInfo == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetDeviceInfo"));
		return;
	}

	
	m_pEE_UASize = (PtrToEE_UASize)GetProcAddress(m_hmodule, TEXT("FT_EE_UASize"));
	if (m_pEE_UASize == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_EE_UASize"));
		return;
	}

	
	m_pEE_UARead = (PtrToEE_UARead)GetProcAddress(m_hmodule, TEXT("FT_EE_UARead"));
	if (m_pEE_UARead == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_EE_UARead"));
		return;
	}

	
	m_pEE_UAWrite = (PtrToEE_UAWrite)GetProcAddress(m_hmodule, TEXT("FT_EE_UAWrite"));
	if (m_pEE_UAWrite == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_EE_UAWrite"));
		return;
	}

	
	m_pSetBitMode = (PtrToSetBitMode)GetProcAddress(m_hmodule, TEXT("FT_SetBitMode"));
	if (m_pSetBitMode == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetBitMode"));
		return;
	}
	
	m_pGetBitMode = (PtrToGetBitMode)GetProcAddress(m_hmodule, TEXT("FT_GetBitMode"));
	if (m_pGetBitMode == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetBitMode"));
		return;
	}
	
	m_pSetEventNotification = (PtrToSetEventNotification)GetProcAddress(m_hmodule, TEXT("FT_SetEventNotification"));
	if (m_pSetEventNotification == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetEventNotification"));
		return;
	}
	
	m_pGetStatus = (PtrToGetStatus)GetProcAddress(m_hmodule, TEXT("FT_GetStatus"));
	if (m_pGetStatus == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetStatus"));
		return;
	}
	
	m_pGetEventStatus = (PtrToGetEventStatus)GetProcAddress(m_hmodule, TEXT("FT_GetEventStatus"));
	if (m_pGetEventStatus == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetEventStatus"));
		return;
	}
	
	m_pSetBaudRate = (PtrToSetBaudRate)GetProcAddress(m_hmodule, TEXT("FT_SetBaudRate"));
	if (m_pSetBaudRate == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_SetBaudRate"));
		return;
	}

	m_pGetDriverVersion = (PtrToGetDriverVersion)GetProcAddress(m_hmodule, TEXT("FT_GetDriverVersion"));
	if (m_pGetDriverVersion == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetDriverVersion"));
		return;
	}

	m_pGetLibraryVersion = (PtrToGetLibraryVersion)GetProcAddress(m_hmodule, TEXT("FT_GetLibraryVersion"));
	if (m_pGetLibraryVersion == NULL)
	{
		AfxMessageBox(TEXT("Error: Can't Find FT_GetLibraryVersion"));
		return;
	}
}

//****************************************************************************************
FT_STATUS CD2XXAccessDlg::Read(LPVOID lpvBuffer, DWORD dwBuffSize, LPDWORD lpdwBytesRead)
{
	DWORD BytesAvail = 0;

	if (!m_pRead)
	{
		AfxMessageBox(TEXT("FT_Read is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pRead)(m_hPort, lpvBuffer, dwBuffSize, lpdwBytesRead);
}	


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::Write(LPVOID lpvBuffer, DWORD dwBuffSize, LPDWORD lpdwBytes)
{
	if (!m_pWrite)
	{
		AfxMessageBox(TEXT("FT_Write is not valid!")); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pWrite)(m_hPort, lpvBuffer, dwBuffSize, lpdwBytes);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::Open(PVOID pvDevice)
{
	if (!m_pOpen)
	{
		AfxMessageBox(TEXT("FT_Open is not valid!")); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pOpen)(pvDevice, &m_hPort );
}	

//****************************************************************************************
FT_STATUS CD2XXAccessDlg::OpenEx(PVOID pArg1, DWORD dwFlags)
{
	if (!m_pOpenEx)
	{
		AfxMessageBox(TEXT("FT_OpenEx is not valid!")); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pOpenEx)(pArg1, dwFlags, &m_hPort);
}	


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::ListDevices(PVOID pArg1, PVOID pArg2, DWORD dwFlags)
{
	if (!m_pListDevices)
	{
		AfxMessageBox(TEXT("FT_ListDevices is not valid!")); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pListDevices)(pArg1, pArg2, dwFlags);
}	


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::Close()
{
	FT_STATUS status;
	static i = 0;
	CString str;
	if (!m_pClose)
	{
		AfxMessageBox(TEXT("FT_Close is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	status = (*m_pClose)(m_hPort);
	m_hPort = NULL;
	return status;
}	



//****************************************************************************************
FT_STATUS CD2XXAccessDlg::ResetDevice()
{
	if (!m_pResetDevice)
	{
		AfxMessageBox(TEXT("FT_ResetDevice is not valid!")); 
		return FT_INVALID_HANDLE;
	}
	
	return (*m_pResetDevice)(m_hPort);
}	



//****************************************************************************************
FT_STATUS CD2XXAccessDlg::Purge(ULONG dwMask)
{
	if (!m_pPurge)
	{
		AfxMessageBox(TEXT("FT_Purge is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pPurge)(m_hPort, dwMask);
}	



//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetTimeouts(ULONG dwReadTimeout, ULONG dwWriteTimeout)
{
	if (!m_pSetTimeouts)
	{
		AfxMessageBox(TEXT("FT_SetTimeouts is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetTimeouts)(m_hPort, dwReadTimeout, dwWriteTimeout);
}	



//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetQueueStatus(LPDWORD lpdwAmountInRxQueue)
{
	if (!m_pGetQueueStatus)
	{
		AfxMessageBox(TEXT("FT_GetQueueStatus is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetQueueStatus)(m_hPort, lpdwAmountInRxQueue);
}



//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetDtr()
{
	if (!m_pSetDtr)
	{
		AfxMessageBox(TEXT("FT_SetDtr is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetDtr)(m_hPort);
}	


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::ClrDtr()
{
	if (!m_pClrDtr)
	{
		AfxMessageBox(TEXT("FT_ClrDtr is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pClrDtr)(m_hPort);
}



//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetRts()
{
	if (!m_pSetRts)
	{
		AfxMessageBox(TEXT("FT_SetRts is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetRts)(m_hPort);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::ClrRts()
{
	if (!m_pClrRts)
	{
		AfxMessageBox(TEXT("FT_ClrRts is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pClrRts)(m_hPort);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetModemStatus(LPDWORD lpdwModemStatus)
{
	if (!m_pGetModemStatus)
	{
		AfxMessageBox(TEXT("FT_GetModemStatus is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetModemStatus)(m_hPort, lpdwModemStatus);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetLatencyTimer(UCHAR ucLatencyTimer)
{
	if (!m_pSetLatencyTimer)
	{
		AfxMessageBox(TEXT("FT_SetLatencyTimer is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetLatencyTimer)(m_hPort, ucLatencyTimer);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetLatencyTimer(PUCHAR pucLatencyTimer)
{
	if (!m_pGetLatencyTimer)
	{
		AfxMessageBox(TEXT("FT_GetLatencyTimer is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetLatencyTimer)(m_hPort, pucLatencyTimer);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetDataCharacteristics(UCHAR uWordLength, UCHAR uStopBits, UCHAR uParity)
{
	if (!m_pSetDataCharacteristics)
	{
		AfxMessageBox(TEXT("FT_SetDataCharacteristics is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetDataCharacteristics)(m_hPort, uWordLength, uStopBits, uParity);
}



//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetChars(UCHAR uEventCh, UCHAR uEventChEn, UCHAR uErrorCh, UCHAR uErrorChEn)
{
	if (!m_pSetChars)
	{
		AfxMessageBox(TEXT("FT_SetChars is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetChars)(m_hPort, uEventCh, uEventChEn, uErrorCh, uErrorChEn);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetFlowControl(USHORT usFlowControl, UCHAR uXon, UCHAR uXoff)
{
	if (!m_pSetFlowControl)
	{
		AfxMessageBox(TEXT("FT_SetFlowControl is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetFlowControl)(m_hPort, usFlowControl, uXon, uXoff);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetBreakOn()
{
	if (!m_pSetBreakOn)
	{
		AfxMessageBox(TEXT("FT_SetBreakOn is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBreakOn)(m_hPort);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetBreakOff()
{
	if (!m_pSetBreakOff)
	{
		AfxMessageBox(TEXT("FT_SetBreakOff is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBreakOff)(m_hPort);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::ResetPort()
{
	if (!m_pResetPort)
	{
		AfxMessageBox(TEXT("FT_ResetPort is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pResetPort)(m_hPort);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetDeviceInfo(FT_DEVICE * lpftDevice, LPDWORD lpdwID, PCHAR pcSerialNumber, PCHAR pcDescription, LPVOID lpDummy)
{
	if (!m_pGetDeviceInfo)
	{
		AfxMessageBox(TEXT("FT_GetDeviceInfo is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetDeviceInfo)(m_hPort, lpftDevice, lpdwID, pcSerialNumber, pcDescription, lpDummy);
}


	
//****************************************************************************************
FT_STATUS CD2XXAccessDlg::EE_UASize(LPDWORD lpdwSize)
{
	if (!m_pEE_UASize)
	{
		AfxMessageBox(TEXT("FT_EE_UASize is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pEE_UASize)(m_hPort,  lpdwSize);
}	

	

//****************************************************************************************
FT_STATUS CD2XXAccessDlg::EE_UARead(PUCHAR pucData, DWORD dwDataLen, LPDWORD lpdwBytesRead)
{
	if (!m_pEE_UARead)
	{
		AfxMessageBox(TEXT("FT_EE_UARead is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pEE_UARead)(m_hPort, pucData, dwDataLen, lpdwBytesRead);
}	

	

//****************************************************************************************
FT_STATUS CD2XXAccessDlg::EE_UAWrite(PUCHAR pucData, DWORD dwDataLen)
{
	if (!m_pEE_UAWrite)
	{
		AfxMessageBox(TEXT("FT_EE_UAWrite is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pEE_UAWrite)(m_hPort, pucData, dwDataLen);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetBitMode(UCHAR ucMask, UCHAR ucEnable)
{
	if (!m_pSetBitMode)
	{
		AfxMessageBox(TEXT("FT_SetBitMode is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBitMode)(m_hPort, ucMask, ucEnable);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetBitMode(PUCHAR pucMode)
{
	if (!m_pGetBitMode)
	{
		AfxMessageBox(TEXT("FT_GetBitMode is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetBitMode)(m_hPort, pucMode);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetEventNotification(DWORD dwEventMask, PVOID pvArg)
{
	if (!m_pSetEventNotification)
	{
		AfxMessageBox(TEXT("FT_SetEventNotification is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetEventNotification)(m_hPort, dwEventMask, pvArg);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetStatus(LPDWORD lpdwAmountInRxQueue, LPDWORD lpdwAmountInTxQueue, LPDWORD lpdwEventStatus )
{
	if (!m_pGetStatus)
	{
		AfxMessageBox(TEXT("FT_GetStatus is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetStatus)(m_hPort, lpdwAmountInRxQueue, lpdwAmountInTxQueue, lpdwEventStatus);
}


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetEventStatus(LPDWORD lpdwEventStatus)
{
	if (!m_pGetEventStatus)
	{
		AfxMessageBox(TEXT("FT_GetEventStatus is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetEventStatus)(m_hPort, lpdwEventStatus);
}	


//****************************************************************************************
FT_STATUS CD2XXAccessDlg::SetBaudRate(DWORD dwBaudRate)
{
	if (!m_pSetBaudRate)
	{
		AfxMessageBox(TEXT("FT_SetBaudRate is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pSetBaudRate)(m_hPort, dwBaudRate);
}	

//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetDriverVersion(LPDWORD pdwDriverVersion)
{
	if (!m_pGetDriverVersion)
	{
		AfxMessageBox(TEXT("FT_GetDriverVersion is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetDriverVersion)(m_hPort, pdwDriverVersion);
}	

//****************************************************************************************
FT_STATUS CD2XXAccessDlg::GetLibraryVersion(LPDWORD pdwDllVersion)
{
	if (!m_pGetLibraryVersion)
	{
		AfxMessageBox(TEXT("FT_GetLibraryVersion is not valid!")); 
		return FT_INVALID_HANDLE;
	}

	return (*m_pGetLibraryVersion)(pdwDllVersion);
}	

//
// Open button press event handler
//
void CD2XXAccessDlg::OnOpen() 
{
	OpenPort(TRUE);
}

//
// Close button press event handler
//
void CD2XXAccessDlg::OnClose() 
{
	ClosePort(TRUE);
}

//
// Write button press event handler
//
void CD2XXAccessDlg::OnWrite() 
{
	BOOL bTrans;
	INT iCount;		

	if(m_hPort == NULL) {
		MessageBox(L"Error", L"Port not open", MB_OK);
		return;
	}

	iCount = (INT)GetDlgItemInt(IDC_WRITE_COUNT, &bTrans, FALSE);

	if(bTrans == TRUE) {
		if((iCount >= COM_BUF_SIZE) && (iCount < 0)) 
			iCount = COM_BUF_SIZE-1;
	}
	else {
		iCount = COM_BUF_SIZE-1;	// always write something
	}

	SetDlgItemInt(IDC_WRITE_COUNT, iCount);

	for(int i = 0; i < iCount; i++) {
		sWriteBuffer.cBuf[i] = (char)(i & 0xFF);
	}
	sWriteBuffer.size = iCount;
	SetEvent(m_hEventWrite);	
}

BOOL CD2XXAccessDlg::DestroyWindow() 
{
	ClosePort(TRUE);
	return CDialog::DestroyWindow();
}

//
//	Name: SendThread
//
//
//	Purpose: Signal from a button press this will send characters to the serial port
//
UINT SendThread (LPVOID pArg) 
{
    DWORD dwBytes, dwWaitReturn;
	CD2XXAccessDlg *pMyHndl = (CD2XXAccessDlg *)pArg;

	pMyHndl->WriteRunning = TRUE;
	//
	// Infinite loop to write to port until close
	//
    while (pMyHndl->fContinue) {

		//
		// Wait for a signal from button press to write
		//
		dwWaitReturn = WaitForSingleObject(pMyHndl->m_hEventWrite, INFINITE);

		//
		// Write size worth of data to the port
		//
		pMyHndl->Write(
			pMyHndl->sWriteBuffer.cBuf, 
			pMyHndl->sWriteBuffer.size,
			&dwBytes
			);
		// on an unplug the write will timeout so no need to check for the return code
	}

	pMyHndl->WriteRunning = FALSE;
    return 0;
}

//
//	Name: ReadThread
//
//
//	Purpose:	Continually receives characters from the serial port if available
//				Also checks for unplug events (new feature in driver)
//
UINT ReadThread (LPVOID pArg) 
{
    DWORD dwBytes = 0, dwError;
    BYTE szText[TEXTSIZE], *pPtr;
	CD2XXAccessDlg *pMyHndl = (CD2XXAccessDlg *)pArg;
	CString str;
	FT_STATUS ftStatus;
	HANDLE hEvent; 
	DWORD EventMask, dwWaitReturn; 
	HANDLE ahEvents[2];

	hEvent = CreateEvent( 	 
				NULL, 
				false, // auto-reset event 
				false, // non-signalled state 
				L"" 
				); 

	ahEvents[0] = hEvent;
	ahEvents[1] = pMyHndl->m_hEventClose;
	EventMask = FT_EVENT_RXCHAR | FT_NOTIFY_ON_UNPLUG; 
	ftStatus = pMyHndl->SetEventNotification(EventMask, hEvent); 

	pMyHndl->ReadRunning = TRUE;
	//
	// Infinite loop to read from port until close
	//
    while (pMyHndl->fContinue) {
		DWORD dwRxQueue, dwTxQueue, dwEventStatus;
		char cBuf[1024];
        pPtr = szText;

		ahEvents[0] = hEvent;
		ahEvents[1] = pMyHndl->m_hEventClose;
		dwWaitReturn = WaitForMultipleObjects(2, ahEvents, FALSE, INFINITE);

		if((dwWaitReturn - WAIT_OBJECT_0) == 0) {
			//
			// Read/Unplug Event
			//

			ftStatus = pMyHndl->GetStatus(&dwRxQueue, &dwTxQueue, &dwEventStatus);
			
			if(ftStatus == FT_OK) {
				if(dwEventStatus & FT_EVENT_RXCHAR) {

					if(dwRxQueue) {
						ftStatus = pMyHndl->Read(
									cBuf, 
									dwRxQueue, 
									&dwBytes
									);
						if(ftStatus == FT_OK) {

							if(dwBytes) {
								if(pMyHndl->m_ReadList.GetCount() > COM_BUF_SIZE-1)
									pMyHndl->m_ReadList.ResetContent();

								for(int i = 0; i < dwBytes; i++) {
									str.Format(L"0x%02X", (cBuf[i] & 0xFF));
									pMyHndl->m_ReadList.AddString(str);
								}
								dwBytes = 0;
							}
						}
						else {
							dwBytes = 0;
							dwError = ::GetLastError();
							if((dwError == ERROR_GEN_FAILURE) || (dwError == ERROR_INVALID_HANDLE)) {
								// Then we can assume we have had an unplug - close the port
								ResetEvent(pMyHndl->m_ReplugEvent);
								pMyHndl->ClosePort(FALSE);
								WaitForSingleObject(pMyHndl->m_ReplugEvent, INFINITE);
								pMyHndl->OpenPort(FALSE);
							}
						}
					}
				}
				else if(dwEventStatus & FT_NOTIFY_ON_UNPLUG) {
					ResetEvent(pMyHndl->m_ReplugEvent);
					pMyHndl->ClosePort(FALSE);
					WaitForSingleObject(pMyHndl->m_ReplugEvent, INFINITE);
					pMyHndl->OpenPort(FALSE);
				}
			}
			EventMask = FT_EVENT_RXCHAR | FT_NOTIFY_ON_UNPLUG; 
			ftStatus = pMyHndl->SetEventNotification(EventMask, hEvent); 
		}
		else if((dwWaitReturn - WAIT_OBJECT_0) == 1) {

			//
			// Close Event
			//
			pMyHndl->fContinue = FALSE;
			// do nothing - fContinue will be set to false and we wont go round the loop again
		}
    }

	if(hEvent) {
		CloseHandle(hEvent);
	}
	pMyHndl->ReadRunning = FALSE;

    return 0;
}

void CD2XXAccessDlg::OnDestroy() 
{
	CDialog::OnDestroy();	
}

//
// Helper funciton for OpenPort
//
void WcharToString(char *pDest, PWCHAR pSrc, ULONG Len)
{
    CHAR *d = pDest;
    WCHAR w;
    char c;

    while (Len--) {
        w = *pSrc++;
        w &= 0x00ff;

        c = (char) w;

        *d++ = c;

        if (w == 0)
            break;
    }
}

//
//	Name: ConvertStringToGuid
//
//
//	Purpose: Helper function	
//
//	Comment:	
//
BOOL 
ConvertStringToGuid(LPCTSTR pszGuid, GUID *pGuid)
{
	UINT Data4[8];
	int  Count;
	BOOL fOk = FALSE;
	TCHAR *pszGuidFormat = _T("{%08lX-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X}");

	__try {
		if(_stscanf(pszGuid, pszGuidFormat, &pGuid->Data1, 
		    &pGuid->Data2, &pGuid->Data3, &Data4[0], &Data4[1], &Data4[2], &Data4[3], 
		    &Data4[4], &Data4[5], &Data4[6], &Data4[7]) == 11) {
			for(Count = 0; Count < (sizeof(Data4) / sizeof(Data4[0])); Count++) {
				pGuid->Data4[Count] = (UCHAR) Data4[Count];
			}
		}
		fOk = TRUE;
	}
	__except(EXCEPTION_EXECUTE_HANDLER){
	}

	return fOk;
}


//
//	Name: CreateGUIDKey
//
//
//	Purpose:	Create the IClass registry entry for this device - enables us to monitor only this device in the NotifyThread
//				You can create your own GUID and place it in the registry if you require	
//
//	Comment:	See windows CE documentation for further details on this feature	
//
void CD2XXAccessDlg::CreateGUIDKey()
{
	DWORD PID_VID;
	HKEY hKey = NULL;
	TCHAR szName[128];

	//
	// Create the appropriate registry entry for the GUID
	//
	GetDeviceInfo(NULL, &PID_VID, NULL, NULL, NULL);

	swprintf(szName, L"Drivers\\USB\\FTDI_%04X\\", (PID_VID & 0x0000FFFF));

	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, szName, 0,	0, &hKey) == ERROR_SUCCESS) {
		
		RegSetValueEx(hKey, L"IClass", 0, REG_SZ, (BYTE *)(&g_GUID), sizeof(g_GUID));
	}

	if(hKey)
		RegCloseKey(hKey);
}

//
//	Name: NotifyThread
//
//
//	Purpose:	Notify of attachment of device	
//
//	Comment:	This reuires an IClass registry setting for the device - see CreateGUID function
//
UINT NotifyThread(LPVOID param)
{
	CD2XXAccessDlg * pDlg = (CD2XXAccessDlg *)param;
	GUID guid = {0};    // or any known and relevant device interface GUID
	HANDLE hq, hn;
	MSGQUEUEOPTIONS msgopts;
	MYDEV detail;
	DWORD flags, size;

	msgopts.dwSize = sizeof(MSGQUEUEOPTIONS);
	msgopts.dwFlags = 0;
	msgopts.dwMaxMessages = 0; //?
	msgopts.cbMaxMessage = sizeof(MYDEV);
    msgopts.bReadAccess = TRUE;
	hq = CreateMsgQueue(NULL, &msgopts);

	pDlg->CreateGUIDKey();

	if (hq == 0) 
		return 0;

	ConvertStringToGuid(g_GUID, &guid);

	hn = RequestDeviceNotifications(&guid, hq, TRUE);

	while(pDlg->fContinue) {
		if(ReadMsgQueue(hq, &detail, sizeof(detail), &size, 1, &flags) == TRUE) {
			if(detail.d.fAttached == TRUE) {
				::SetEvent(pDlg->m_ReplugEvent);
			}
		}
	}
	return 0;
}

//
//	Name: OpenPort
//
//
//	Purpose: To open the device and setup all the related threads for monitoring reads/notify and writes	
//
//	Comment:	
//
BOOL CD2XXAccessDlg::OpenPort(BOOL bStartThreads)
{
	CString str;
	FT_STATUS ftStatus;
	DWORD dwOpenFlag;

	if(!m_hPort) {

		dwOpenFlag = dwListDescFlags & ~FT_LIST_ALL;

		if(dwOpenFlag == 0) {
			INT iSel;

			iSel = SendDlgItemMessage (IDC_CMB_PORTS, CB_GETCURSEL, 0, 0);
			//
			// Opening by number only
			//
			ftStatus = Open((PVOID)iSel);

		}
		else {
			char cDescription[256];

			//
			// Get Selected COM (or other if prefix has changed) port name from list box
			//
			GetDlgItemText(IDC_CMB_PORTS, str);

			WcharToString(cDescription, str.GetBuffer(str.GetLength()), str.GetLength());
			cDescription[str.GetLength()] = (char)NULL;

			//
			// Open the port
			//
			ftStatus = OpenEx((PVOID)(LPCTSTR)cDescription, dwOpenFlag);
		}

		if(ftStatus == FT_OK) {
			DWORD dwDriverVersion;

			ftStatus = GetDriverVersion(&dwDriverVersion);
			if(ftStatus == FT_OK) {
				CString str;

				str.Format(L"%d.%d.%d.%d", 
					(int)((char)((dwDriverVersion & 0xFF000000) >> 24)),
					(int)((char)((dwDriverVersion & 0x00FF0000) >> 16)),
					(int)((char)((dwDriverVersion & 0x0000FF00) >> 8)),
					(int)((char)((dwDriverVersion & 0x000000FF))));
				SetDlgItemText(IDC_DRIVER_VERSION, str);
			}

			//
			// Setup the port
			//
			SetBaudRate(9600);	
			
			//
			// Purge the Device
			//
			Purge((FT_PURGE_RX | FT_PURGE_TX));

			//
			// Set the read and write timeouts
			//
			SetTimeouts(3000, 3000);

			if(bStartThreads == TRUE) {
				//
				// Initialise the Send and Receive threads
				//
				fContinue		= TRUE;
				m_hEventWrite	= CreateEvent(NULL, FALSE, FALSE, NULL);
				m_hEventClose	= CreateEvent(NULL, FALSE, FALSE, NULL);
				m_ReplugEvent		= CreateEvent(NULL, TRUE, FALSE, NULL);
				pThreadRead		= AfxBeginThread(ReadThread, this, THREAD_PRIORITY_NORMAL);
				pThreadWrite	= AfxBeginThread(SendThread, this, THREAD_PRIORITY_NORMAL);
				pThreadNotify	= AfxBeginThread(NotifyThread, this, THREAD_PRIORITY_NORMAL);	

				//
				// Enable buttons that can be pressed
				//
				GetDlgItem(IDC_CLOSE)->EnableWindow(TRUE);
				GetDlgItem(IDC_OPEN)->EnableWindow(FALSE);
				GetDlgItem(IDC_WRITE)->EnableWindow(TRUE);
				GetDlgItem(IDC_DESCRIPTION)->EnableWindow(FALSE);
				GetDlgItem(IDC_SERIAL)->EnableWindow(FALSE);
				GetDlgItem(IDC_NUMBER)->EnableWindow(FALSE);
			}
		}
		else {
			//
			// Failed to open - return false
			//
			m_hPort = NULL;
			return FALSE;
		}
	}

	return TRUE;
}

//
//	Name: ClosePort
//
//
//	Purpose:	Close the currently opened port
//				Terminate the Send and Receive threads
//
//	Comment:	Can only be called if port is open
//
BOOL CD2XXAccessDlg::ClosePort(BOOL bSetButtons)
{
	if(bSetButtons == TRUE) {

		SetTimeouts(100, 100);

		//
		// Stop both threads from looping
		//
		fContinue = FALSE;

		SetEvent(m_hEventClose);

		if(pThreadRead) {
			
			//
			// Terminate the Read thread
			//
			if((ReadRunning != FALSE) && (WaitForSingleObject(pThreadRead->m_hThread, READ_THREAD_WAIT_TIMEOUT) == WAIT_TIMEOUT)) {
				
				//
				// Didn't exit nicely so kill it
				//
				MessageBox(L"Error RThread");
				TerminateThread(pThreadRead->m_hThread, 0xffffffff);
			}
		}

		//
		// Stop the writing thread by signal
		//
		if(pThreadWrite) {

			sWriteBuffer.size = 0;

			SetEvent(m_hEventWrite);
			
			//
			// Terminate the Write thread
			//
			if((WriteRunning != TRUE) && (WaitForSingleObject(pThreadWrite->m_hThread, WRITE_THREAD_WAIT_TIMEOUT) == WAIT_TIMEOUT)) {
				
				//
				// Didn't exit nicely so kill it
				//
				MessageBox(L"Error WThread");
				TerminateThread(pThreadWrite->m_hThread, 0xffffffff);	
			}
		}

		//
		// Release this resource
		//
		if(m_hEventWrite) {
			CloseHandle(m_hEventWrite);
		}

		//
		// Release this resource
		//
		if(m_hEventClose) {
			CloseHandle(m_hEventClose);
		}

		//
		// Enable buttons that can be pressed
		//
		GetDlgItem(IDC_CLOSE)->EnableWindow(FALSE);
		GetDlgItem(IDC_OPEN)->EnableWindow(TRUE);
		GetDlgItem(IDC_WRITE)->EnableWindow(FALSE);
		GetDlgItem(IDC_DESCRIPTION)->EnableWindow(TRUE);
		GetDlgItem(IDC_SERIAL)->EnableWindow(TRUE);
		GetDlgItem(IDC_NUMBER)->EnableWindow(TRUE);
		SetEvent(m_ReplugEvent);
	}

	if(m_hPort) {
		Close();
		m_hPort = NULL;
	}

	return TRUE;
}

void CD2XXAccessDlg::SetUpDevList(INT iDlgID)
{
	INT iSel;

	iSel = SendDlgItemMessage (iDlgID, CB_GETCURSEL, 0, 0);

	ListUnopenDevices(iDlgID);

	//
	// Select the first one in the list
	// 
	if(iSel != CB_ERR) {
		SendDlgItemMessage (iDlgID, CB_SETCURSEL, (WPARAM)iSel, 0);
	}
	else {
		SendDlgItemMessage (iDlgID, CB_SETCURSEL, 0, 0);
	}
}

//
// Helper function for ListUnopenDevices
//
void StringToWchar(PWCHAR pDest, char * pSrc, ULONG Len)
{
    WCHAR *d = pDest;
    WCHAR w;
    char c;

    while (Len--) {

        c = *pSrc++;
        w = (WCHAR)c;

        *d++ = w;

        if (w == 0)
            break;
    }
}

BOOL CD2XXAccessDlg::ListUnopenDevices(INT iDlgID)
{
	FT_STATUS ftStatus;
	DWORD numDevs;
	TCHAR wstr[64];

	UpdateData(TRUE);
	SendDlgItemMessage (iDlgID, CB_RESETCONTENT, 0, 0);
	UpdateData(FALSE);
	UpdateWindow();

	ftStatus = ListDevices(&numDevs, NULL, FT_LIST_NUMBER_ONLY);

	if(ftStatus == FT_OK) {
		if(dwListDescFlags == FT_LIST_ALL) {
			//
			// Only list the numbers
			//
			for(DWORD u=0; u<numDevs; u++) {
				swprintf(wstr, L"%d", u);
				SendDlgItemMessage (iDlgID, CB_INSERTSTRING, -1, (LPARAM)wstr);
			}
		}
		else {
			// FT_ListDevices OK, show number of devices connected in list box
			ftStatus = ListDevices(&numDevs, NULL, FT_LIST_NUMBER_ONLY);
			if(ftStatus == FT_OK) {

				char *BufPtrs[64]; // pointer to array of 64 pointers
				for(DWORD d=0; d<numDevs; d++) {
					BufPtrs[d] = new char[64];
				}
				BufPtrs[d] = NULL;

				ftStatus = ListDevices(BufPtrs, &numDevs, dwListDescFlags);

				if (ftStatus == FT_OK) {
					for(DWORD u=0; u<numDevs; u++) {
						StringToWchar(wstr, BufPtrs[u], strlen(BufPtrs[u])+1);
						SendDlgItemMessage (iDlgID, CB_INSERTSTRING, -1, (LPARAM)wstr);
					}
				}
				else {
					AfxMessageBox(_T("FT_ListDevices failed")); 
					return FALSE;
				}	

				//
				// free ram to avoid memory leaks
				//
				for(d=0; d<numDevs; d++) {
					delete BufPtrs[d];  
				}
			}	
		}
	}
	else {
		// FT_ListDevices failed
		AfxMessageBox(_T("FT_ListDevices failed")); 
		return FALSE;
	}
	return TRUE;
}

//
// Radio button description click handler
//
void CD2XXAccessDlg::OnDescription() 
{
	dwListDescFlags = FT_LIST_ALL | FT_OPEN_BY_DESCRIPTION;
	SetUpDevList(IDC_CMB_PORTS);
}

//
// Radio button number click handler
//
void CD2XXAccessDlg::OnNumber() 
{
	dwListDescFlags = FT_LIST_ALL;	
	SetUpDevList(IDC_CMB_PORTS);
}

//
// Radio button serial number click handler
//
void CD2XXAccessDlg::OnSerial() 
{
	dwListDescFlags = FT_LIST_ALL | FT_OPEN_BY_SERIAL_NUMBER;	
	SetUpDevList(IDC_CMB_PORTS);
}
