/*
** Filename: CDCModem.c
**
** Automatically created by Application Wizard 1.4.2
**
** Part of solution CDCModem in project CDCModem
**
** Comments:
**
** Important: Sections between markers "FTDI:S*" and "FTDI:E*" will be overwritten by
** the Application Wizard
*/

#include "CDCModem.h"

/* Default settings for UART interface */
#define DEF_UART_BAUD		UART_BAUD_9600
#define DEF_UART_DATA_BITS	UART_DATA_BITS_8
#define DEF_UART_FLOW		UART_FLOW_RTS_CTS
#define DEF_UART_STOP_BITS	UART_STOP_BITS_1
#define DEF_UART_PARITY		UART_PARITY_NONE

/* FTDI:STP Thread Prototypes */
vos_tcb_t *tcbCDC2UART;
vos_tcb_t *tcbUART2CDC;

void CDC2UART();
void UART2CDC();
/* FTDI:ETP */

/* FTDI:SDH Driver Handles */
VOS_HANDLE hUSBHOST_1;                 // USB Host Port 1
VOS_HANDLE hUART;                      // UART Interface Driver
VOS_HANDLE hUSB_CDC_DRIVER;            // Connects to an CDC Device using Abstract Serial Notification on the USB Host
                                       // Interface
/* FTDI:EDH */

vos_mutex_t mInit;

/* Declaration for IOMUx setup function */
void iomux_setup(void);

/* Main code - entry point to firmware */
void main(void)
{
	/* FTDI:SDD Driver Declarations */
	// UART Driver configuration context
	uart_context_t uartContext;
	// USB Host configuration context
	usbhost_context_t usbhostContext;

	/* FTDI:EDD */

	/* FTDI:SKI Kernel Initialisation */
	vos_init(50, VOS_TICK_INTERVAL, VOS_NUMBER_DEVICES);
	vos_set_clock_frequency(VOS_48MHZ_CLOCK_FREQUENCY);
	vos_set_idle_thread_tcb_size(512);
	/* FTDI:EKI */

	iomux_setup();

	/* FTDI:SDI Driver Initialisation */
	// Initialise UART
	uartContext.buffer_size = VOS_BUFFER_SIZE_128_BYTES;
	uart_init(VOS_DEV_UART, &uartContext);

	// Initialise USB CDC  Device
	usbHostCDC_init(VOS_DEV_USB_CDC_DRIVER);

	// Initialise USB Host
	usbhostContext.if_count = 8;
	usbhostContext.ep_count = 16;
	usbhostContext.xfer_count = 2;
	usbhostContext.iso_xfer_count = 2;
	usbhost_init(VOS_DEV_USBHOST_1, -1, &usbhostContext);
	/* FTDI:EDI */

	/* FTDI:SCT Thread Creation */
	tcbCDC2UART = vos_create_thread_ex(20, 1536, CDC2UART, "CDC2UART", 0);
	tcbUART2CDC = vos_create_thread_ex(20, 512, UART2CDC, "UART2CDC", 0);
	/* FTDI:ECT */

	vos_init_mutex(&mInit, 1);

	vos_start_scheduler();

main_loop:
	goto main_loop;
}

/* FTDI:SSP Support Functions */

unsigned char usbhost_connect_state(VOS_HANDLE hUSB)
{
	unsigned char connectstate = PORT_STATE_DISCONNECTED;
	usbhost_ioctl_cb_t hc_iocb;

	if (hUSB)
	{
		hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_GET_CONNECT_STATE;
		hc_iocb.get = &connectstate;
		vos_dev_ioctl(hUSB, &hc_iocb);

		// repeat if connected to see if we move to enumerated
		if (connectstate == PORT_STATE_CONNECTED)
		{
			vos_dev_ioctl(hUSB, &hc_iocb);
		}
	}

	return connectstate;
}

VOS_HANDLE cdc_host_attach(VOS_HANDLE hUSB, unsigned char devHostCDC)
{
	usbhost_device_handle_ex ifCDCControl, ifCDCData;
	usbhost_ioctl_cb_t hc_iocb;
	usbhost_ioctl_cb_class_t hc_iocb_class;
	common_ioctl_cb_t cdc_iocb;
	usbHostCDC_ioctl_cb_attach_t cdc_attach;
	VOS_HANDLE hHostCDC;

	// find CDC Control class device
	hc_iocb_class.dev_class = USB_CLASS_CDC_CONTROL;
	hc_iocb_class.dev_subclass = USB_SUBCLASS_CDC_CONTROL_ABSTRACT;
	hc_iocb_class.dev_protocol = 1;

	// user ioctl to find first device
	hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_DEVICE_FIND_HANDLE_BY_CLASS;
	hc_iocb.handle.dif = NULL;
	hc_iocb.set = &hc_iocb_class;
	hc_iocb.get = &ifCDCControl;

	if (vos_dev_ioctl(hUSB, &hc_iocb) != USBHOST_OK)
	{
		return NULL;
	}

	// user ioctl to find CDC Data device
	// by definition it must be the interface following the CDC control device
	hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_DEVICE_GET_NEXT_HANDLE;
	hc_iocb.handle.dif = ifCDCControl;
	hc_iocb.get = &ifCDCData;

	if (vos_dev_ioctl(hUSB, &hc_iocb) != USBHOST_OK)
	{
		return NULL;
	}

	// Check that the found device is indeed a data device
	hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_DEVICE_GET_CLASS_INFO;
	hc_iocb.handle.dif = ifCDCData;
	hc_iocb.get = &hc_iocb_class;

	if (vos_dev_ioctl(hUSB, &hc_iocb) != USBHOST_OK)
	{
		return NULL;
	}

	// verify the USB class information for the data class
	if ((hc_iocb_class.dev_class != USB_CLASS_CDC_DATA) ||
		(hc_iocb_class.dev_subclass != 0) ||
		(hc_iocb_class.dev_protocol != 0))
	{
		return NULL;
	}

	// now we have a device, intialise a CDC driver with it
	hHostCDC = vos_dev_open(devHostCDC);

	cdc_attach.hc_handle = hUSB;
	cdc_attach.ifCtrl = ifCDCControl;
	cdc_attach.ifData = ifCDCData;

	cdc_iocb.ioctl_code = VOS_IOCTL_USBHOSTCDC_ATTACH;
	cdc_iocb.set.data = &cdc_attach;

	if (vos_dev_ioctl(hHostCDC, &cdc_iocb) != USBHOSTCDC_OK)
	{
		vos_dev_close(hHostCDC);
		return NULL;
	}

	return hHostCDC;
}

void cdc_host_detach(VOS_HANDLE hHostCDC)
{
	common_ioctl_cb_t cdc_iocb;

	if (hHostCDC)
	{
		cdc_iocb.ioctl_code = VOS_IOCTL_USBHOSTCDC_DETACH;

		vos_dev_ioctl(hHostCDC, &cdc_iocb);
		vos_dev_close(hHostCDC);
	}
}

/* FTDI:ESP */

void open_drivers(void)
{
	/* Code for opening and closing drivers - move to required places in Application Threads */
	/* FTDI:SDA Driver Open */
	hUSBHOST_1 = vos_dev_open(VOS_DEV_USBHOST_1);
	hUART = vos_dev_open(VOS_DEV_UART);
	/* FTDI:EDA */
}

void attach_drivers(void)
{
	/* FTDI:SUA Layered Driver Attach Function Calls */
	hUSB_CDC_DRIVER = cdc_host_attach(hUSBHOST_1, VOS_DEV_USB_CDC_DRIVER);
	/* FTDI:EUA */
}

void close_drivers(void)
{
	/* FTDI:SDB Driver Close */
	vos_dev_close(hUSBHOST_1);
	vos_dev_close(hUART);
	/* FTDI:EDB */
}

/* Application Threads */

void CDC2UART()
{
	unsigned char status;

	// communications ioctl request blocks
	common_ioctl_cb_t CDC_iocb;
	usbHostCDC_line_coding_t CDC_line;
	common_ioctl_cb_t uart_iocb;

	// Host Controller ioctl request block
	usbhost_ioctl_cb_t hc_iocb;

	unsigned char leds;
	unsigned short lineStatus;

	unsigned char buffer[64];
	unsigned short dataAvail, actual;

	open_drivers();

	uart_iocb.ioctl_code = VOS_IOCTL_COMMON_ENABLE_DMA;
	uart_iocb.set.param = DMA_ACQUIRE_AS_REQUIRED;
	vos_dev_ioctl(hUART, &uart_iocb);

	// UART set baud rate
	uart_iocb.ioctl_code = VOS_IOCTL_UART_SET_BAUD_RATE;
	uart_iocb.set.uart_baud_rate = DEF_UART_BAUD;
	vos_dev_ioctl(hUART, &uart_iocb);

	// UART set flow control
	uart_iocb.ioctl_code = VOS_IOCTL_UART_SET_FLOW_CONTROL;
	uart_iocb.set.param = DEF_UART_FLOW;
	vos_dev_ioctl(hUART, &uart_iocb);

	// UART set data bits
	uart_iocb.ioctl_code = VOS_IOCTL_UART_SET_DATA_BITS;
	uart_iocb.set.param = DEF_UART_DATA_BITS;
	vos_dev_ioctl(hUART, &uart_iocb);

	// UART set stop bits
	uart_iocb.ioctl_code = VOS_IOCTL_UART_SET_STOP_BITS;
	uart_iocb.set.param = DEF_UART_STOP_BITS;
	vos_dev_ioctl(hUART, &uart_iocb);

	// UART set parity
	uart_iocb.ioctl_code = VOS_IOCTL_UART_SET_PARITY;
	uart_iocb.set.param = DEF_UART_PARITY;
	vos_dev_ioctl(hUART, &uart_iocb);

	// Host Controller Setup
	hc_iocb.ioctl_code = VOS_IOCTL_USBHOST_SET_HANDLE_MODE_EXTENDED;
	vos_dev_ioctl(hUSBHOST_1, &hc_iocb);

	// GPIO Set LED pins to outputs
	vos_gpio_set_port_mode(GPIO_PORT_A, 0xff);  // set all as output

	do
	{
		// wait for enumeration to complete
		vos_delay_msecs(250);
		leds = LED3;
		vos_gpio_write_port(GPIO_PORT_A, leds);
		vos_delay_msecs(250);
		leds = 0;
		vos_gpio_write_port(GPIO_PORT_A, leds);

		// find Mobile phone
		hUSB_CDC_DRIVER = cdc_host_attach(hUSBHOST_1, VOS_DEV_USB_CDC_DRIVER);

		if (hUSB_CDC_DRIVER)
		{
			// Obtain the line coding information for the CDC device
			CDC_iocb.ioctl_code = VOS_IOCTL_USBHOSTCDC_GET_LINE_CODING;
			CDC_iocb.get.data = &CDC_line;

			if (vos_dev_ioctl(hUSB_CDC_DRIVER, &CDC_iocb) != USBHOSTCDC_OK)
			{
				leds = LED5;
				vos_gpio_write_port(GPIO_PORT_A, leds);
				continue;
			}

			// Turn off DTE present and Carrier Active signal
			lineStatus = 0;
			CDC_iocb.ioctl_code = VOS_IOCTL_USBHOSTCDC_SET_LINE_CONTROL_STATE;
			CDC_iocb.set.data = &lineStatus;

			if (vos_dev_ioctl(hUSB_CDC_DRIVER, &CDC_iocb) != USBHOSTCDC_OK)
			{
				leds = LED5;
				vos_gpio_write_port(GPIO_PORT_A, leds);
				continue;
			}

			// Turn on the DTE present and Carrier Active signals
			lineStatus = (USBHOSTCDC_DTE_PRESENT | USBHOSTCDC_ACTIVATE_CARRIER);
			CDC_iocb.ioctl_code = VOS_IOCTL_USBHOSTCDC_SET_LINE_CONTROL_STATE;
			CDC_iocb.set.data = &lineStatus;

			if (vos_dev_ioctl(hUSB_CDC_DRIVER, &CDC_iocb) != USBHOSTCDC_OK)
			{
				leds = LED5;
				vos_gpio_write_port(GPIO_PORT_A, leds);
				continue;
			}

			// Set the line coding information back to the previous setting
			CDC_iocb.ioctl_code = VOS_IOCTL_USBHOSTCDC_SET_LINE_CODING;
			CDC_iocb.set.data = &CDC_line;

			if (vos_dev_ioctl(hUSB_CDC_DRIVER, &CDC_iocb) != USBHOSTCDC_OK)
			{
				leds = LED5;
				vos_gpio_write_port(GPIO_PORT_A, leds);
				continue;
			}

			// Turn on the DTE present and Carrier Active signals
			lineStatus = (USBHOSTCDC_DTE_PRESENT | USBHOSTCDC_ACTIVATE_CARRIER);
			CDC_iocb.ioctl_code = VOS_IOCTL_USBHOSTCDC_SET_LINE_CONTROL_STATE;
			CDC_iocb.set.data = &lineStatus;

			if (vos_dev_ioctl(hUSB_CDC_DRIVER, &CDC_iocb) != USBHOSTCDC_OK)
			{
				leds = LED5;
				vos_gpio_write_port(GPIO_PORT_A, leds);
				continue;
			}

			// Start polling - will stop automatically when device removed
			CDC_iocb.ioctl_code = VOS_IOCTL_USBHOSTCDC_START_POLL;

			if (vos_dev_ioctl(hUSB_CDC_DRIVER, &CDC_iocb) != USBHOSTCDC_OK)
			{
				leds = LED5;
				vos_gpio_write_port(GPIO_PORT_A, leds);
				continue;
			}

			leds = LED4;
			vos_gpio_write_port(GPIO_PORT_A, leds);

			// Signal other thread to say everything is initialised and ready
			vos_unlock_mutex(&mInit);

			do
			{
				// get amount of data read from device
				CDC_iocb.ioctl_code = VOS_IOCTL_COMMON_GET_RX_QUEUE_STATUS;
				status = vos_dev_ioctl(hUSB_CDC_DRIVER, &CDC_iocb);

				if (status != USBHOSTCDC_OK)
				{
					leds = LED5;
					vos_gpio_write_port(GPIO_PORT_A, leds);
					break;
				}

				dataAvail = CDC_iocb.get.queue_stat;

				if (dataAvail > 0)
				{
					// Real read from CDC device
					// number of bytes received in buffer returned in actual
					status = vos_dev_read(hUSB_CDC_DRIVER, buffer, dataAvail, &actual);

					if (status != USBHOSTCDC_OK)
					{
						leds = LED5;
						vos_gpio_write_port(GPIO_PORT_A, leds);
						break;
					}

					// then write to UART
					if (actual > 0)
					{
						leds = 0;
						vos_gpio_write_port(GPIO_PORT_A, leds);

						status = vos_dev_write(hUART, buffer, actual, NULL);

						if (status != UART_OK)
						{
							leds = LED5;
							vos_gpio_write_port(GPIO_PORT_A, leds);
							break;
						}

						leds = LED4;
						vos_gpio_write_port(GPIO_PORT_A, leds);
					}
				}
			}
			while (1);

			vos_lock_mutex(&mInit);

			cdc_host_detach(hUSB_CDC_DRIVER);
		}
	}
	while (1);
}

void UART2CDC()
{
	unsigned char status;
	unsigned char buffer[64];

	common_ioctl_cb_t uart_iocb;
	unsigned short dataAvail, actual;

	unsigned char leds;

	do
	{
		// wait for other thread to complete initialisation sequence
		vos_lock_mutex(&mInit);

		uart_iocb.ioctl_code = VOS_IOCTL_COMMON_GET_RX_QUEUE_STATUS;
		vos_dev_ioctl(hUART, &uart_iocb);

		dataAvail = uart_iocb.get.queue_stat;

		if (dataAvail > sizeof(buffer))
		{
			dataAvail = sizeof(buffer);
		}

		if (dataAvail > 0)
		{
			// read from UART
			status = vos_dev_read(hUART, buffer, dataAvail, &actual);

			if (status != UART_OK)
			{
				leds = LED5;
				vos_gpio_write_port(GPIO_PORT_A, leds);
				break;
			}

			leds = 0;
			vos_gpio_write_port(GPIO_PORT_A, leds);

			// then write to CDC device
			status = vos_dev_write(hUSB_CDC_DRIVER, buffer, actual, NULL);

			if (status != USBHOSTCDC_OK)
			{
				leds = LED5;
				vos_gpio_write_port(GPIO_PORT_A, leds);
				break;
			}

			leds = LED4;
			vos_gpio_write_port(GPIO_PORT_A, leds);
		}

		vos_unlock_mutex(&mInit);
	}
	while (1);
}

